#ifndef __savegame__
#define __savegame__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   savegame.h                                                            *
*			Description:                    *
*			This file contains functions and definitions used to save and load						*
*			game state.																																		*
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

/*
Notes:

Data to be saved:

-Player struct

-All room data:
 -Room struct
 -Tilemap
 -Enemies
 -Items
 
 
-Visited rooms indicator
 
 
 
-Global data:
 -Event array
 -Gamedata?





File Structure:

-struct savefile
-Slot 1
-Slot 2
-Slot 3



*/


#define SaveFileName	    "metrsave"
#define TempSaveFileName  "mtsa____"

#define SaveFileMagicNumber		0xDEADBEEF



typedef struct{	
	
	// Some data to make it easier for the user to identify the save games:
	short Area;
	char Name[10];
	
}savegame;

typedef struct{
	
	unsigned long MagicNumber;
	
	short RawSize[3];
	short CompSize[3];
	short SlotOffset[3];
	short Roomsize[3];
	
}savefile;

short SaveGame(short Slot);

short LoadGame(short Slot);











#endif