#ifndef __object__
#define __object__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   object.h                                                              *
*			Description:                   *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

#define NrOfObjectSlots		5


#define XPlosionLifeTime	12
#define XPlosionStep1Time	4

#define SeriesXPlosionLifeTime	120

#define FragmentFlyTime	50
#define SamusKilledAnimTime	100


typedef struct{
	short Type;
	short Active;
	
	short Handler;
	short Sprite;
	
	short X;
	short Y;
	
	short Data0;
	short Data1;
	short Data2;
	short Data3;
	short Data4;
	
}object;

extern object Objects[NrOfObjectSlots];

enum ObjectTypes{
	
	ObjSingleExplosion=1,
	ObjSeriesExplosions=2,
	ObjFlyingFragments=3,
	ObjSamusKilled=4,
};

void RenderObjects();

void ObjectHandler1(object* Object);

void ObjectHandler2(object* Object);

void ObjectHandler3(object* Object);

void ObjectHandler4(object* Object);

void AddFlyingFragments(short X,short Y);

void AddSingleExplosion(short X,short Y);

void AddSeriesExplosion(short X,short Y,short Height,short Width,short Slot);

void AddSamusKilledAnim();

short FindFreeObjectSlot();









#endif