
#include "all.h"

const char *MainMenu[4]={/*"Metroid:",*/"New Game","Load Game","Options","Quit"};
const char *SaveMenu[3]={/*"Save game:",*/"Game 1","Game 2","Game 3"};
const char *InGameMenu[4]={/*"In-game menu:",*/"Continue","Save","Options","Quit"};
const char *LoadMenu[3]={/*"Load game:",*/"Game 1","Game 2","Game 3"};
const char *OptionsMenu[4]={/*"Options",*/"Keys","Speed","Set defaults","Back"};

void Disp(const char* Txt){
	
	DrawGrayStrExt2B(3,3,Txt,A_NORMAL,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	
	while(!_rowread(0));//wait until key pressed
	while(_rowread(0));//wait until key released

};

void DispNum(short Num1,short Num2,short Num3,short Y){
	char String[24];
	
	sprintf(String,"%d,%d,%d",Num1,Num2,Num3);
	
	DrawGrayStrExt2B(3,Y,String,A_NORMAL,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	
	while(!_rowread(0));//wait until key pressed
	while(_rowread(0));//wait until key released

};


short DoMenu(const char **Content,short NrOfOptions){
	short Cursor=0,C;
	
	unsigned short* Sprite = Sprites16 + SpriteTab[88].Offset;	
	short Height = SpriteTab[88].Height;
	unsigned short* Mask = Sprite+2*Height;//Sprites16+32*4;
	//while(_rowread(0));//wait until key released
	InitStarField();
	
	#ifdef MakeTI89
		#define MX 48
		#define MY (16+16)
	#endif
	#ifdef MakeTI92Plus
		#define MX 80
		#define MY (12+16)
	#endif
	#ifdef MakeV200
		#define MX 80
		#define MY (12+16)
	#endif
	
	while(1){
		
	//	while(_rowread(0));//wait until key released
		#ifdef MakeTI89
			while( _keytest(RR_ESC) || _keytest(RR_ENTER) );
		#endif
		#ifdef MakeTI92Plus
			while( _keytest(RR_ESC) || _keytest(RR_ENTER1) || _keytest(RR_ENTER2) );
		#endif
		#ifdef MakeV200
			while( _keytest(RR_ESC) || _keytest(RR_ENTER1) || _keytest(RR_ENTER2) );
		#endif
		
		StarFieldAnim();
				
		// Draw options
		for(C=0;C<NrOfOptions;C++){			
			DrawGrayStrExt2B(MX,MY+C*16,Content[C],A_REVERSE/*A_NORMAL*/,F_8x10,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		};

		// Draw Cursor
		GrayClipSprite16_SMASK_R(MX-20,MY+Cursor*16,Height,Sprite,Sprite+Height,Mask,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		
		GrayDBufToggleSync();
		
		
		ScanKeys();
		
		ContrastAdjust();
		
		if(KeyState.Esc){
			while(_rowread(0));//wait until key released
			Wait();//idle();//wait	
			KeyState.Esc = 0;
			return 0;
		};
		if(KeyState.Enter){			
			while(_rowread(0));//wait until key released
			Wait();//idle();//wait	
			KeyState.Enter = 0;
			return Cursor+1;
		};
		if(KeyState.Up){
			if((--Cursor)<0){
				Cursor = NrOfOptions-1;				
			};
			Wait();
		};
		if(KeyState.Down){
			if((++Cursor)>=NrOfOptions){
				Cursor = 0;
			};
			Wait();
		};		
		
	};	
	
};

void KeyConfig(){
	
	short KeyConfig[5];
	short Cursor=0,C;
	
	unsigned short* Sprite = Sprites16 + SpriteTab[88].Offset;	
	short Height = SpriteTab[88].Height;
	unsigned short* Mask = Sprite+2*Height;//Sprites16+32*4;
	//while(_rowread(0));//wait until key released
	InitStarField();
	
	#ifdef MakeTI89
		#define MX 48
		#define MX2 90
		#define MY (16)
		const char* Keys[6]={"[2nd]","[Shift]","[Diamond]","[Alpha]","[Clear]","[APPS]"};
	#endif
	#ifdef MakeTI92Plus
		#define MX 32
		#define MX2 90
		#define MY (12+16)
		const char* Keys[6]={"[Hand]","[F1]","[F2]","[F5]","[Clear]","[Q]"};
	#endif
	#ifdef MakeV200
		#define MX 32
		#define MX2 90
		#define MY (12+16)
		const char* Keys[6]={"[Hand]","[Q]","[F1]","[W]","[Clear]","[Shift]"};
	#endif
	
	const char *KeyMenu[5]={"Jump","Fire","Weapon","Map","Stats"};
	
	memcpy(&KeyConfig,&Config.KeyConfig,5*sizeof(short));
	
	while(1){
		
		while(_rowread(0));//wait until key released
		
		StarFieldAnim();
				
  	// Draw options
		for(C=0;C<=4;C++){			
			DrawGrayStrExt2B(MX,MY+C*16,KeyMenu[C],A_REVERSE,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
			DrawGrayStrExt2B(MX2,MY+C*16,Keys[KeyConfig[C]],A_REVERSE,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		};

		// Draw Cursor
		GrayClipSprite16_SMASK_R(MX-20,MY+(Cursor)*16,Height,Sprite,Sprite+Height,Mask,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		
		GrayDBufToggleSync();
				
		ScanKeys();
		
		ContrastAdjust();
				
		if(KeyState.Up){
			if((--Cursor)<0){
				Cursor = 4;
			};
		};
		if(KeyState.Down){
			if((++Cursor)>4){
				Cursor = 0;
			};
		};
		if(KeyState.Left){
			if( (--KeyConfig[Cursor])<0 ){
				KeyConfig[Cursor] = 5;
			};
		};
		if(KeyState.Right){
			if( (++KeyConfig[Cursor])>5 ){
				KeyConfig[Cursor] = 0;
			};
		};
		
		if(KeyState.Esc){
			KeyState.Esc = 0;
			return;
		};		
		if(KeyState.Enter){			
			KeyState.Enter = 0;
			while(_rowread(0));//wait until key released
			
			// Make sure not duplicate keys
			short C,D,Duplicate = 0;
			
			for(C=0;C<5;C++){
				for(D=0;D<5;D++){
					if(C!=D){
						if(KeyConfig[C]==KeyConfig[D]){
							Duplicate = 1;
						};
					};
				};
			};
			
			if(Duplicate == 0){
				memcpy(&Config.KeyConfig,&KeyConfig,5*sizeof(short));
				SaveConfig();
				return;
			}
			else{
				// Draw Frame and white rect inside
				/*GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),22,20,138,80,COLOR_DARKGRAY);
				GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),23,21,137,79,COLOR_DARKGRAY);

				GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE),24,22,136,78,COLOR_WHITE);//  COLOR_LIGHTGRAY  COLOR_WHITE
				*/
				
				DispFramedRectangle();
				
				#ifdef MakeTI89					
				#define TY			35	
				#endif
				#ifdef MakeTI92Plus	
				#define TY			49	
				#endif
				#ifdef MakeV200	
				#define TY			49	
				#endif
				
				// Draw text
				DrawGrayStrExt2B(0,TY,"Duplicate keys",A_REPLACE|A_SHADOWED|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
				DrawGrayStrExt2B(0,TY+10,"not allowed",A_REPLACE|A_SHADOWED|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));

				WaitForKeyPress();
				
			};
			
		};
		
	};	
	
};

void SpeedSelect(){
	
	#define NrOsSpeedOpts	12
	
	// Assume AI1 runs at 372 Hz on HW1, 256 on the rest
	
	/*
	const char* SpeedOpts[NrOsSpeedOpts] = {"<12>","<13>","<14>","<15>","<16>","<17>","<18>","<20>","<22>","<23>","<25>","<Max>"};
  
	short SpeedVals[2][NrOsSpeedOpts] = {		
											{        21,    19,    18,    17,    16,    15,    14,    13,    12,    11,    10,    0},
											{        31,    29,    27,    25,    23,    22,    21,    19,    17,    16,    15,    0},
	};*/
	
	//const char* SpeedOpts[NrOsSpeedOpts] = {/*"<12>","<13>","<14>",*/"<15>","<16>","<17>","<18>","<20>","<22>","<23>","<25>","<28>","<32>","<36>","<Max>"};
  const char* SpeedOpts[NrOsSpeedOpts] = {/*"<12>","<13>","<14>",*/"<1>","<2>","<3>","<4>","<5>","<6>","<7>","<8>","<9>","<10>","<11>","<Max>"};
  
  
	const short SpeedVals[2][NrOsSpeedOpts] = {		
																		{       /* 21,    19,    18,*/    17,    16,    15,    14,    13,    12,    11,    10,     9,     8,     7,    0},
																		{       /* 31,    29,    27,*/    25,    23,    22,    21,    19,    17,    16,    15,    13,    11,    10,    0},
	};
	
	short C;
	short Selected=0;
	short HWIdx = (HW_VERSION==1?1:0);
	//short HWIdx = (HW_VERSION==1?0:0);// HW1 support disabled during testing...
	
	for(C=0;C<NrOsSpeedOpts;C++){
		if(SpeedVals[HWIdx][C]==Config.Speed){
			Selected = C;
		};
	};	
	if( (Selected>(NrOsSpeedOpts-1)) || (Selected<0) ){
		Selected = 0;
	};
	
	InitStarField();
	
	while(1){
		
		while(_rowread(0));//wait until key released
	
		StarFieldAnim();
		
		DrawGrayStrExt2B(0,40,"Game speed:",A_REVERSE|A_CENTERED,F_8x10,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		
		DrawGrayStrExt2B(0,60,SpeedOpts[Selected],A_REVERSE|A_CENTERED,F_8x10,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
				
		GrayDBufToggleSync();
		
		ScanKeys();		
		
		ContrastAdjust();
		
		if(KeyState.Esc){
			KeyState.Esc = 0;
			while(_rowread(0));//wait until key released
			
			return;
		};
		if(KeyState.Enter){
			KeyState.Enter = 0;
			while(_rowread(0));//wait until key released
			Config.Speed = SpeedVals[HWIdx][Selected];
			SaveConfig();
			return;
		};		
				
		if(KeyState.Left || KeyState.Down){
			if( (--Selected)<0 ){
				Selected = 11;
			};
		};
		if(KeyState.Right || KeyState.Up){
			if( (++Selected)>11 ){
				Selected = 0;
			};
		};		
		
	};//End of while(1)
	
	#undef NrOsSpeedOpts
	
};

void Menus(){
	short Option;
	
	if( (ErrorCode = DoTitleScreen()) ){
		// Map file not found
		return;
	};
	
	while(!Exit){		
		
		// Main menu
		Option = DoMenu(MainMenu,4);
		
		if(Option == 1){
			
			// New game
			PlayerInit();
			if( (ErrorCode = LoadArea(0)) ){ // 0  1  2  3  4  5  6  7
				// Map file not found
				ErrorCode = 4;
				return;
			};
			if( (ErrorCode = LoadEvents()) ){ 
				// Map file not found
				ErrorCode = 4;
				return;
			};
			//  1  2   3   4  4r  5   5r  6    7   8r12
			// 0  10  40  54  58  86  93 121  143    171
			if( (ErrorCode = LoadRoom(0)) ){ 
				// Map file not found
				ErrorCode = 4;
				return;
			};
			
			if(ErrorCode==0){
				memset(VisitedRooms,-1,TotalNrOfRooms*sizeof(char));
				VisitedRooms[0] = 2;
				PlayLoop();
			}
			else{
				// Should not happend
			};		
			
		};
		if(Option == 2){
			// Load game
			
			short Slot = DoMenu(LoadMenu,3);
			
			if( (Slot>=1) && (Slot<=3) ){
				
				if(LoadGame(Slot-1)==0){
								
					if( (ErrorCode = LoadArea(Player.CurrArea)) ){ // 0  1  2  3  4  5
						// Map file not found
						ErrorCode = 4;
						return;
					};
					PlayLoop();
				
				};
			};			
			
		};
		if(Option == 3){
			// Options
			
			short Select = DoMenu(OptionsMenu,3);
			
			switch(Select){
				case 1:
					KeyConfig();
				break;
				case 2:
					SpeedSelect();
				break;
				case 3:
					SetDefaultConfig();
					SaveConfig();
				break;
			};
			
		};
		Exit = 0;
		if( (Option == 4) || (Option == 0) ){
			// Quit
			Exit = 1;
		};
		
	};	
	
	
};

