
#include "all.h"

gamestate Gamestate;

config Config;

void SetDefaultConfig(){
	
	#ifdef MakeTI89
		Config.Speed = (HW_VERSION==1?13:9);
		Config.KeyConfig[0] = 0;
		Config.KeyConfig[1] = 2;
		Config.KeyConfig[2] = 1;
		Config.KeyConfig[3] = 4;
		Config.KeyConfig[4] = 5;
	#endif
	#ifdef MakeTI92Plus
		Config.Speed = 9;
		Config.KeyConfig[0] = 1;
		Config.KeyConfig[1] = 2;
		Config.KeyConfig[2] = 3;
		Config.KeyConfig[3] = 4;
		Config.KeyConfig[4] = 5;
	#endif
	#ifdef MakeV200
		Config.Speed = 9;
		Config.KeyConfig[0] = 0;
		Config.KeyConfig[1] = 1;
		Config.KeyConfig[2] = 3;
		Config.KeyConfig[3] = 4;
		Config.KeyConfig[4] = 5;
	#endif
	
};

void Wait(){
	unsigned short C;
	for(C=0;C<60000;C++);
};

void LoadConfig(){
	
	HANDLE ConfigFileH;
	
	if( (ConfigFileH = File_get_pointer_and_lock("metconf"))==H_NULL ){
		// Config file not found: Load default values
		
		SetDefaultConfig();
		
		SaveConfig();
	}
	else{
	
		void* Ptr = HeapDeref(ConfigFileH)+2;
	
		memcpy(&Config,Ptr,sizeof(config));
	
	};
	
	HeapUnlock(ConfigFileH);
	
};

void SaveConfig(){
	FILES NewFile;	
	
	if(FOpen ("metconf", &NewFile, FM_WRITE, "CONF")!=FS_OK){
		goto failure;
	};
	
	if(FWrite(&Config,sizeof(config),&NewFile)!=FS_OK){
		goto failure;
	};
	
	FClose (&NewFile); 
	
	return;
	
	failure:	
	// Could not save config file
	DrawGrayStrExt2B(0,35,"Could not save config!!",A_REVERSE|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
							
	// wait for keypress	
	WaitForKeyPress();
	
};

void HandleAdditionalControls(){
	// Handles Additional controls. Those are:
	// In-Game menu
	// Adjust contrast
	// Teacher/Boss key
	// MiniMap display
	// Statscreen display	
	
	if(KeyState.Esc){
		//Exit = 1;
		
		short Option = DoMenu(InGameMenu,4);
		
		if(Option==2){
			// Save
			short Slot = DoMenu(SaveMenu,3);
			
			if( (Slot>=1) && (Slot<=3) ){
				SaveGame(Slot-1);
			};			
			
		};
		if(Option==3){
		
		short Select = DoMenu(OptionsMenu,3);
			
			switch(Select){
				case 1:
					KeyConfig();
				break;
				case 2:
					SpeedSelect();
				break;
				case 3:
					SetDefaultConfig();
					SaveConfig();
				break;
			};		
		
		};
		if(Option==4){
			Exit = 1;
		};		
		
		FgPlane.p.force_update = 1;
		while(_rowread(0));
		//Gamestate.SpeedCounter = 0;
	};
	
	if(KeyState.Enter){
		off();// Teacher key: Turn the calc off
		KeyState.Enter = 0;
		
	};
	
	ContrastAdjust();
		
	if(KeyState.Clear){		
		DoMinimap(Player.CurrArea);		
		//Gamestate.SpeedCounter = 0;
	};
	
	if(KeyState.Stats){		
		DoStatScreen();
		//Gamestate.SpeedCounter = 0;
	};	
	
};

void ContrastAdjust(){
	/*******************************************************************************************
	This function adjusts the contrast settings by pressing the +/- keys.
	********************************************************************************************/
	
	if(Gamestate.Count1==0){
		if(KeyState.Plus){
			OSContrastUp();
		}
		else{
			if(KeyState.Minus){
				OSContrastDn();
			};
		};
	};	
	
};