
#include "all.h"


HANDLE File_get_pointer_and_lock(const char* FileName){
// Retrievs a pointer to the content of a file. 
// Locks the file to protect against garbage collection
// 
//
// Parameters:
// const char* FileName
// The name of the file to open
//
// return:
// A HANDLE, pointer to the content of the file.
// Returns H_NULL on errer.

	
	SYM_ENTRY *File_sym;
	HANDLE Temp; 
		
	if( !(File_sym = SymFindPtr (SYMSTR(FileName), 0)) )
   	return H_NULL;//error 
  
  if( !(Temp = File_sym->handle) )
	  return H_NULL;//error
	
	if( !(HeapLock( File_sym->handle ))  )//lock memblocks used by file
		return H_NULL;//error
	
	return Temp;
		
};


short ArchiveFile(short Size, const char* FileName){
	
	short Tries = 0;
	
	while(Tries<2){//0 or 1 try
		
		if( EM_findEmptySlot(Size) ){//large enough empty slot in archive mem?
			//save:
						
			// Archive
			if( !EM_moveSymToExtMem ( SYMSTR(FileName), HS_NULL ) ){
				goto failure;
			}
			break;// Break out of while loop
		}
		else{//No free flash mem blocks that are large enough 
			//Garbage collect, display no dialog
			
			if(Tries>0)// Tried garbage collection already, no point in trying twice
				goto failure;
			
			if(EM_GC (FALSE)){
				
			};
			Tries++;	
				
		};		
	};
	
	return 0;
	
	failure:
	
	return 1;
	
}