
#include "all.h"


respawningTile RespawningTiles[NrOfRespawnTiles];


void RespawnTiles(){
		
	short C;
	
	for(C=0;C<NrOfRespawnTiles;C++){
		
		if(RespawningTiles[C].ActiveTimer){
			
			if((--RespawningTiles[C].ActiveTimer)<=0){
				PutTile(RespawningTiles[C].X*16,RespawningTiles[C].Y*16,RespawningTiles[C].OriginalTile);
			}
			else{
				short Offset = (RespawningTiles[C].OriginalTile==WhiteRespawnTile?0:1);
				switch(RespawningTiles[C].ActiveTimer){
					
					case (TileRespawnTime-TileRespawnAnimTime):
					case (TileRespawnAnimTime*2):
						PutTile(RespawningTiles[C].X*16,RespawningTiles[C].Y*16,RespawningTiles[C].OriginalTile-RespawnTileIdxDist+1-Offset);
					break;
					case (TileRespawnTime-2*TileRespawnAnimTime):
						PutTile(RespawningTiles[C].X*16,RespawningTiles[C].Y*16,0);

					break;
					/*case (TileRespawnAnimTime*2):
						PutTile(RespawningTiles[C].X*16,RespawningTiles[C].Y*16,RespawningTiles[C].OriginalTile-RespawnTileIdxDist+1-Offset);
					break;*/
					case TileRespawnAnimTime:
						PutTile(RespawningTiles[C].X*16,RespawningTiles[C].Y*16,RespawningTiles[C].OriginalTile-RespawnTileIdxDist-Offset);
					break;					
					
				};
				
			};						
		};		
	};	
	
};
/*
void ReplaceTile(unsigned char OldTile,unsigned char NewTile){
	short X,Y;
	
	for(X=0;X<Room->Width;X++){
		for(Y=0;Y<Room->Height;Y++){
			if(GetTile(X*16,Y*16)==OldTile){
				PutTile(X*16,Y*16,NewTile);
			};
		};
	};
	
};*/
void RemoveLavaAndDoors(){
	short X,Y;
	unsigned char Tile;
	
	for(X=0;X<Room->Width;X++){
		for(Y=0;Y<Room->Height;Y++){
			
			Tile = GetTile(X*16,Y*16);
			if((Tile==tile_lava) || ((Tile>=tiles_solid_missile_shootable_low) && (Tile<=tiles_solid_missile_shootable_high)) ){
				PutTile(X*16,Y*16,0);
			};
			
		};
	};
	
};


void ReplaceNonSolidByLava(){
	short X,Y;
	
	for(X=0;X<Room->Width;X++){
		for(Y=0;Y<Room->Height;Y++){
			if(GetTile(X*16,Y*16)<=tiles_non_solid_high){
				PutTile(X*16,Y*16,tile_lava);
			};
		};
	};
	
};

unsigned char GetTile(short X,short Y){
	
	if( (X>=(Room->Width*16)) || (X<0) || (Y>=(Room->Height*16)) || (Y<0) ){
		return 0;
	}
	else{	
		return *( (char*)(FgPlane.p.matrix+(Y>>4)*FgPlane.p.width+(X>>4)) );
	};
	
};

void PutTile(short X,short Y,unsigned char Tile){
	
	*( (char*)(FgPlane.p.matrix+(Y>>4)*FgPlane.p.width+(X>>4)) ) = Tile;
	FgPlane.p.force_update = 1;
	
};

short FreeLeft(short X,short Y,short Height){
	//Description:
	//Chcecks if a rectangular object is free to move leftwards.
	//Works with heights up to 32
	
	//Parameters:
	//X and Y: Coordinates of the upper left included corner of the object 
	//Height: The height of the object
	
	//Return:
	//The length of the free path, or 16
	
	
/*	short Dist = 16,Xi,C;
	short H = Height-1;
	
	for(C=0;C<=(Height-1);C+=min(16,Height-1)){
		
//		H -= min(16,H-1);
		
		if( (GetTile(X-16,Y+C)>=tiles_solid_low) && (GetTile(X-16,Y+C)<=tiles_solid_high) )
			Dist = (X)&0x000f;//(X)%16;// = 		//distance to next tile left
		
	}
	
	if( (GetTile(X-16,Y+Height-1)>=tiles_solid_low) && (GetTile(X-16,Y+Height-1)<=tiles_solid_high) )
			Dist = (X)&0x000f;//(X)%16;// = 		//distance to next tile left
*/	
	
	short Dist = 16,C;
	
	short dY[3];
	
	dY[0]=0;
	dY[1]=min(15,Height-1);//Height>>2;
	dY[2]=Height-1;
	
	for(C=0;C<=2;C++){
		
		if( (GetTile(X-16,Y+dY[C])>=tiles_solid_low) && (GetTile(X-16,Y+dY[C])<=tiles_solid_high) )
			Dist = (X)&0x000f;//(X)%16;
					
	}	
	
	return Dist;
};

short FreeRight(short X,short Y,short Height){
	//Description:
	//Chcecks if a rectangular object is free to move rightwards.
	//Works with heights up to 32
	
	//Parameters:
	//X and Y: Coordinates of the upper right included corner of the object 
	//Height: The height of the object
	
	//Return:
	//The length of the free path, or 16
	
//	short Dist = 16,Xi,C;
	
//	for(C=0;C<=(Height-1);C+=min(16,Height-1)){
		
		// Uncomment the /*15*/ 's to make this a width16 func
//		if((GetTile(X+15/*+15*/,Y+C)>=tiles_solid_low) && (GetTile(X+15/*+15*/,Y+C)<=tiles_solid_high) )
//			Dist = 15-((X/*+15*/)&0x000f);//15-(X/*+15*/)%16;// 		//distance to next tile right
		
//	};
	
	
short Dist = 16,C;
	
	short dY[3];
	
	dY[0]=0;
	dY[1]=min(15,Height-1);//Height>>2;
	dY[2]=Height-1;
	
	for(C=0;C<=2;C++){
		
		if((GetTile(X+15,Y+dY[C])>=tiles_solid_low) && (GetTile(X+15,Y+dY[C])<=tiles_solid_high) )
			Dist = 15-((X)&0x000f);//15-(X)%16;

	}

	return Dist;
};

short FreeUp(short X,short Y,short Width){
	
/*
	if( (GetTile(X,Y-15)>=tiles_solid_low) || (GetTile(X+15,Y-15)>=tiles_solid_low) )
		return ((Y)&0x000f);//return ((Y)%16);	//distance to next tile down	//Val = 15-(Enemy->Y+Enemy->Height-1)%16;	
	else
		return 16;	//return Val;
*/	
	
	short Dist = 16,C;	
	
	for(C=0;C<=(Width-1);C+=min(16,Width-1)){
		
		if( (GetTile(X+C,Y-15)>=tiles_solid_low) /*|| (GetTile(X+C+15,Y-15)>=tiles_solid_low)*/ )
			Dist = ((Y)&0x000f);//return ((Y)%16);	//distance to next tile down	//Val = 15-(Enemy->Y+Enemy->Height-1)%16;	
	
	};
	
	return Dist;
};

short FreeDown(short X,short Y,short Width){
	
	short Dist = 16,C;
	
	for(C=0;C<=(Width-1);C+=min(16,Width-1)){
		
		if( (GetTile(X+C,Y+15)>=tiles_solid_low) /*|| (GetTile(X+C+15,Y+15)>=tiles_solid_low)*/ ){
			Dist = (15-((Y/*-1*/)&0x000f));
		};		
		
	};	
	
	return Dist;
};


void InitializeTilemap(){
	
	Gamestate.FgX = 0;
	Gamestate.FgY = 0;
	FgPlane.p.force_update = 1;
	FgPlane.nb_anim = 256;
	FgPlane.nb_step = 1;
	FgPlane.step = 0;
	FgPlane.step_length = 99;
	FgPlane.frame = 0;		
	
};







