#ifndef __player__
#define __player__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   player.h                                                              *
*			Description:                    *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

// Compile time settings for player

#define InitialEnergyLevel			100
#define InitialMissileLoad			30
#define InitialBeamWeapon				beam

#define player_jumpspeed							4
#define player_fallspeed							4
#define player_walkspeed							2


#define player_normal_jumpheight  		72
#define player_hijump_jumpheight  		(player_normal_jumpheight*2)
#define player_springball_jumpheight  48
#define player_ball_bounceheight			10
#define player_spacejumpheight				60
#define player_hijump_spacejumpheight	(player_spacejumpheight*2)
//#define player_spacejumpheight				48


#define springball_normal_jumpheight	48
#define springball_hijump_jumpheight	springball_normal_jumpheight*2


#define nr_of_player_shots				10
#define	player_fire_interval			15
#define	player_bomb_interval			15
#define bomb_countdown_time				50


#define player_immortal_time			20

#define hostile_tile_damage				5
#define respawn_tile_damage				2

extern const short PlayerAnimTab[14][8];
extern const short VariaPlayerAnimTab[14][8];

typedef struct{
	
	short X;
	short Y;
	
	short AX;
	short AY;
	short CurrArea;
	short RoomUpdate;
//	short CurrRoomIdx;
	
	
	short ForceXMove;
	short Blocked;
	short ForceXMoveSpeed;
	
	short Dir;
	short Aim;
	
	short State;
	
	short Sprite;
	short Height;
	
	short IsInWater;
	short WalkSpeed;
	
	short IsWalking;
	short WalkAnimStep;
	short WalkAnimTimer;
	short IsJumping;
	short IsFalling;
	short IsBounchingBall;
	short IsSpinJumping;
	short SpaceJumpFailed;
	
	short SpiderCurrXDir;
	short SpiderCurrYDir;
	short SpiderPrefXDir;
	short SpiderPrefYDir;
	short SpiderPrevKeyLeft;
	short SpiderPrevKeyRight;
	short SpiderPrevKeyUp;
	short SpiderPrevKeyDown;	
	
	// SpiderStateLeftTimer fixes a bug where you could enter ducking mode through solid roof 
	// when pressing Up and Jump simultaniously in spider ball mode. 
	// The workaround is to prevent player from entering ducking mode a number of frames
	// after exiting spider ball mode.
	short SpiderStateLeftTimer;
	// PreventSpiderCount prevents a bug that bounches samus through solid tiles if she enters
	// spider ball mode while in contact with enemy.
	// The workaround is to prevent player from entering spider ball mode a number of frames 
	// after beeing in contact with an enemy i.e a call to PlayerWounded();
	short PreventSpiderCount;
	
	short BlockBombJump;
	
	short Energy;
	short MaxEnergyLevel;

	short ActiveWeapon;
	
	short BeamWeapon;
	short ShootTimer;
	
	short Missiles;
	short MaxMissileLoad;
	// The number of missiles the player has
	
	
	//PowerUp status:
	short HasHighJump;
	short HasSpringBall;
	short HasSpiderBall;
	short HasSpaceJump;
	short HasScrewAttack;
	short HasVariaSuit;
	short HasBomb;
	
	
	short ShakeCounter;
	
	short Immortal;
	
	short Test;	
	
	
}player;

typedef struct{
	short X;
	short Y;
	
	short Sprite;
	short Handler;
	
	short Active;
	short Dx;
	short Dy;
	
	short Type;
	
	short D0;
	short D1;
	short D2;
	
}shot;

enum MapTransitionParameters{
	XLeft = 1,
	XRight = 2,
	YUp = 3,
	YDown = 4,
	AUp = 5,
	ADown = 6,
};

enum BulletTypes{
	BTnormalBeam=0, BTiceBeam=1, BTwaveBeam=2, BTspazerBeam=3, BTplasmaBeam=4, 
	BTexplosion=5, BTmissile = 6, BTbomb=7, 
};

enum WeaponStates {
	beam_active=0,missile_active=1,
};

enum PlayerStates {
	normal=0,ducking=1,morph_ball=2,spider_ball=3,spring_ball=4,
};

enum PlayerWeapons {
	beam=0,ice_beam=1,wawe_beam=2,spazer_lazer_beam=3,plasma_beam=4
};

enum PlayerWeaponDamages{
	// Beam weapons
	beam_damage=10,ice_beam_damage=10,wawe_beam_damage=15,
	spazer_lazer_beam_damage=15,plasma_beam_damage=20,
	// Bombs
	bomb_damage=15,
	// Missiles
	missile_damage=30,
	// Explosion
	explosion_damage=15,
	
};

enum AimDirs {
	aim_up=-1,aim_down=1,aim_left=-2,aim_right=2
};

extern player Player;

extern shot PlayerShots[nr_of_player_shots];

void PlayerInit();

void ExitSPiderBallMode();

short PlayerFreeLeft(short X,short Y,short Height);

short PlayerFreeRight(short X,short Y,short Height);

short PlayerFreeUp(short X,short Y,short Width);

short PlayerFreeDown(short X,short Y,short Width);

short PlayerWrapAroundUp();

void HandlePlayer();



void PlayerShoot();

void AddBomb();

short FindFreePlayerShotSlot();

void ShotHandler1(shot* Shot);

void ShotHandler2(shot* Shot);

void ShotHandler3(shot* Shot);

void ShotHandler4(shot* Shot);

void ShotHandler5(shot* Shot);

void HandlePlayerShots();

short KillShootableTiles(short X,short Y,short W,short H);

void PlayerWounded(short Damage);



#endif