
#include "all.h"


object Objects[NrOfObjectSlots];


void RenderObjects(){
	// Handles and renders all animation objects
	
	short C;
	
	for(C=0;C<NrOfObjectSlots;C++){
		if(Objects[C].Active){
			
			// Handle			
			if(Objects[C].Handler){
				switch(Objects[C].Handler){
					case 1:
						ObjectHandler1(&Objects[C]);
					break;
					case 2:
						ObjectHandler2(&Objects[C]);
					break;
					case 3:
						ObjectHandler3(&Objects[C]);
					break;
					case 4:
						ObjectHandler4(&Objects[C]);
					break;
				};
			};
			
			// Draw			
			if(Objects[C].Type==ObjFlyingFragments){
				// Special case: Falling fragments
				DrawSprite(Objects[C].X+Objects[C].Data0,Objects[C].Y+Objects[C].Data1,Objects[C].Sprite,0);
				DrawSprite(Objects[C].X-Objects[C].Data0,Objects[C].Y+Objects[C].Data1,Objects[C].Sprite,0);
				DrawSprite(Objects[C].X,Objects[C].Y+Objects[C].Data1-4,Objects[C].Sprite,0);
			
			}
			else{
				
				if(Objects[C].Type==ObjSamusKilled){

					short Co;					
					const short Dx[6]={1,-1,1,-1,1,-1};
					const short Dy[6]={1,1,-1,-1,0,0};
									
					for(Co=0;Co<6;Co++){
						DrawSprite(Objects[C].X+Objects[C].Data0*Dx[Co],Objects[C].Y+Objects[C].Data1*Dy[Co],Objects[C].Sprite,0);
					};
										
					/*
					DrawSprite(Objects[C].X+Objects[C].Data0,Objects[C].Y+Objects[C].Data1,Objects[C].Sprite,0);
					DrawSprite(Objects[C].X-Objects[C].Data0,Objects[C].Y+Objects[C].Data1,Objects[C].Sprite,0);
					DrawSprite(Objects[C].X+Objects[C].Data0,Objects[C].Y-Objects[C].Data1,Objects[C].Sprite,0);
					DrawSprite(Objects[C].X-Objects[C].Data0,Objects[C].Y-Objects[C].Data1,Objects[C].Sprite,0);
					DrawSprite(Objects[C].X+Objects[C].Data0,Objects[C].Y+4,Objects[C].Sprite,0);
					DrawSprite(Objects[C].X-Objects[C].Data0,Objects[C].Y+4,Objects[C].Sprite,0);
					*/

				}
				else{
					DrawSprite(Objects[C].X,Objects[C].Y,Objects[C].Sprite,0);
				};				
			};			
			
			Objects[C].Active--;
		};
	};
	
};

void ObjectHandler1(object* Object){
	
	if( Object->Active<=(XPlosionLifeTime-XPlosionStep1Time) ){
		Object->Sprite = 94;
	};
	
};

void ObjectHandler2(object* Object){
	
	if( (--Object->Data0)<=0 ){
		Object->Sprite = 94;
		Object->Data0 = XPlosionLifeTime-XPlosionStep1Time;
		Object->X = Object->Data3 + random(Object->Data1);
		Object->Y = Object->Data4 + random(Object->Data2);
	};
	
	if(Object->Active==1){
		
		if(Object->Type>=0){
			Enemies[Object->Type].Life = 0;
		}
		else{
			short Dy;
			
			for(Dy=0;Dy<=32;Dy+=16){
				PutTile(Object->Data3,Object->Data4+Dy,0);
			};
						
		};
		
	};
	
};

void ObjectHandler3(object* Object){
	// Handle flying fragments	
	
	if(Object->Data0<32){
		Object->Data0++;
	};
	
	Object->Data1 += 3;
	
};

void ObjectHandler4(object* Object){
	
	Object->Data0 += 2;
	Object->Data1 += 2;
//	Object->Data0++;
//	Object->Data1++;
	
	if(Object->Active==2){
		GameOver();
		Exit = 1;
	};
	
};

void AddFlyingFragments(short X,short Y){
	short C;
	
	if( (C=FindFreeObjectSlot())>=0 ){
		Objects[C].Active = FragmentFlyTime;
		Objects[C].Type = ObjFlyingFragments;
		Objects[C].Handler = 3;
		Objects[C].Sprite = 262;
		Objects[C].X = X;
		Objects[C].Y = Y;
		Objects[C].Data0 = 0;
		Objects[C].Data1 = 0;
	};	
	
};

void AddSamusKilledAnim(){
	short C;
	
	if( (C=FindFreeObjectSlot())>=0 ){
		
		Objects[C].Active = SamusKilledAnimTime;
		Objects[C].Type = ObjSamusKilled;
		Objects[C].Handler = 4;
		Objects[C].Sprite = 262;
		Objects[C].X = Player.X+8;
		Objects[C].Y = Player.Y+8;
		Objects[C].Data0 = 0;
		Objects[C].Data1 = 0;
	};
	
};

void AddSingleExplosion(short X,short Y){
	short C;
	
	if( (C=FindFreeObjectSlot())>=0 ){
		Objects[C].Active = XPlosionLifeTime;
		Objects[C].Type = ObjSingleExplosion;
		Objects[C].Handler = 1;
		Objects[C].Sprite = 93;
		Objects[C].X = X;
		Objects[C].Y = Y;
	};	
	
};

void AddSeriesExplosion(short X,short Y,short Height,short Width,short Slot){
	short C;
	
	if( (C=FindFreeObjectSlot())>=0 ){
		Objects[C].Active = SeriesXPlosionLifeTime;
		Objects[C].Type = (Slot>=0?Slot:-1);
		Objects[C].Handler = 2;
		Objects[C].Sprite = 93;
		Objects[C].X = Objects[C].Data3 = X;
		Objects[C].Y = Objects[C].Data4 = Y;
		Objects[C].Data0 = XPlosionLifeTime;
		Objects[C].Data1 = Width;
		Objects[C].Data2 = Height;
	};	
	
};

short FindFreeObjectSlot(){
	short C;
	
	for(C=0;C<NrOfObjectSlots;C++){
		if(Objects[C].Active==0){
			return C;
		}
	};
	
	return -1;// No free slots
	
};