
#include "all.h"

void* LevelArray;
void* AreaArray;
HANDLE Mapfile_sym_h;
void* MapArchive;
area* Area;
unsigned char* AreaMap;
char* YCorrMap;
char* XCorrMap;


room* Room;


short InitMapfilePointer(){
	
	if( (Mapfile_sym_h = File_get_pointer_and_lock("metromap"))==H_NULL ){
		return 4;
	};
	
	if( (MapArchive=HLock(Mapfile_sym_h))==NULL ){// Lock and dereference the file
		return 4;
	};
	
	MapArchive += 2; // Skip "lenght of file" - bytes
			
	// Valid ttarchive?
	if ( !ttarchive_valid(MapArchive) ) {
		return 4;// invalid archive
	};
	
	//Allocate memory
	if( ( LevelArray=malloc(3*1024) )==NULL ){
		return 1;
	};
	
	if( ( AreaArray=malloc(512*sizeof(char)) )==NULL ){
		return 1;
	};
	
	if( ( EventArray=malloc( NrOfEvents*sizeof(short) ) )==NULL ){
		return 1;
	};
	
	
	return 0;
};

short LoadArea(short Index){	
	
	if( ttunpack_decompress(ttarchive_data(MapArchive,Index),AreaArray) != TTUNPACK_OKAY ){
		return 4;// failure
	};	
	
	Area = AreaArray;
	
	//Player.Test = Area->Width;
	
	AreaMap = AreaArray + sizeof(area);
	
//	Player.Test = *(AreaMap+19);
	
	XCorrMap = AreaMap + Area->Height*Area->Width;
	
	YCorrMap = XCorrMap + (Area->Height-1)*Area->Width;
	
	return 0;
};

short LoadRoom(short Index){
	
	//Player.Test = Index;
		
	// Demo setup: The end
	#ifdef demo1
	if( (Index>41) && (Index<84) ){
		Exit = -1;
	};
	#endif
	#ifdef demo2
	if( Player.CurrArea >= 4 ){
		Exit = -1;
	};
	#endif
	// End of demo setup
	
	// Map file should already be open
	
	Index += ArchiveStartOfRooms;		
	
	//Player.Test = Player.AY;
	
	//Player.Test = Index;
	
//	Player.Test = *(AreaMap+Player.AY*Area->Width+Player.AX);	
	
	
	memset(Blocks,0,max_nr_of_blocks*sizeof(block));	
	memset(Enemyshots,0,nr_of_enemy_shots*sizeof(shot));	
	memset(PlayerShots,0,nr_of_player_shots*sizeof(shot));	
	memset(Objects,0,NrOfObjectSlots*sizeof(object));
	memset(RespawningTiles,0,NrOfRespawnTiles*sizeof(respawningTile));
	
	if( ttunpack_decompress(ttarchive_data(MapArchive,Index),LevelArray) != TTUNPACK_OKAY ){
		return 4;// failure
	};
	
	short Idx = Player.AY*Area->Width+Player.AX;
	
	if(Idx>=26)
		Idx++;
	
	SetAsVisited(Idx);

	Room = LevelArray;
	
	
	Enemies = LevelArray + sizeof(room);
	Items = ((void*)Enemies) + Room->NrOfEnemies*sizeof(enemy);
	FgPlane.p.matrix = ((void*)Items) + Room->NrOfItems*sizeof(item);
		
	FgPlane.p.width = Room->Width;		
	
	// Event check: Remove taken items.	
	short C;
	for(C=0;C<Room->NrOfItems;C++){			
		if(Items[C].Event){
			if(EventArray[Items[C].Event]==0){
				Items[C].Active = 0;
			};
			if(Items[C].Active==2){
				Blocks[0].X = Items[C].X;
				Blocks[0].Y = Items[C].Y;
				Blocks[0].Height = 16;
				Blocks[0].Width = 16;// 
				Blocks[0].Index = C;
				Blocks[0].Active = item_block_time;
			};
		};		
	};
	
	// Event check: Remove killed metroids.	Update Metroid's life
	for(C=0;C<Room->NrOfEnemies;C++){		
		if(Enemies[C].TypeAttrib & 0b0000000001000001){// Metroid or energy barrier
			Enemies[C].Life = EventArray[Enemies[C].Misc];
		};
	};
	
	// Event check: Remove blasted doors.	
	if(Room->Event){	
		if(EventArray[Room->Event]<=0){
			RemoveLavaAndDoors();
		};
	};
	
	// Event check: Fill with lava if previous Area not completed
	if(EventArray[Player.CurrArea]!=0){
		ReplaceNonSolidByLava();
	};	
	
	/*if(Gamestate.FinalCountDown && ((Index-ArchiveStartOfRooms)==BrainRoomIndex) ){
		SetMBrainKilledEnvironment();
	};*/
	if( (EventArray[MBrainEventIndex]==0) && ((Index-ArchiveStartOfRooms)==BrainRoomIndex) ){
		SetMBrainKilledEnvironment();
	};
	
//	Player.Test = EventArray[Player.CurrArea];
	
//	Player.CurrRoomIdx = Index;
	
	return 0;
};
/*
void LoadEnemies(char* Raw){
	short Curr = 0,L;
	
	// Test code	
	
	if( (Enemies = malloc(Room->NrOfEnemies*sizeof(enemy)))==NULL ){
		Room->NrOfEnemies = 0;
		return;		
	}
	
	// End of test code	
	
	
	const short CrawlerStartValues[8][4]={
	//Dir,D0,D2,D3
		{-1, 0,-1,-1,}, // RoofLeft
		{ 1, 0, 1,-1,}, // RoofRight
		{-1, 0,-1, 1,}, // FloorLeft
		{ 1, 0, 1, 1,}, // FloorRight
		
		{ 0,-1,-1,-1,}, // CeilingLeftUp
		{ 0, 1,-1, 1,}, // CeilingLeftDown
		{ 0,-1, 1,-1,}, // CeilingRightUp
		{ 0, 1, 1, 1,}, // CeilingRightDown
		
	};
	
	
	memset(Enemies,0,Room->NrOfEnemies*sizeof(enemy));
	
	for(Curr=0;Curr<Room->NrOfEnemies;Curr++){
		
		L = 3;
		
		char Model = *Raw;
		short X = (*(Raw+1))*16;
		short Y = (*(Raw+2))*16;
		char B1 =(*(Raw+3));
		char B2 =(*(Raw+4));
		
		
		Enemies[Curr].X = X;
		Enemies[Curr].Y = Y;
		
		Enemies[Curr].Anim = AnimByFrame2Step;
		Enemies[Curr].Life = 10;
		
		//Handler 1 enemies have some common stuff...
		if( (Model>=handler1enemiesLow) && (Model<=handler1enemiesHigh) ){
			Enemies[Curr].Handler = 1;
			Enemies[Curr].Dir = -1;
			Enemies[Curr].Data0 = Enemies[Curr].Data1 = 16*B1;
			Enemies[Curr].TypeAttrib = 0b0000000000000010;
			L = 4;
		};		
		
		
		switch(Model){			
			
			case 0:// Dummy test case
				Enemies[Curr].Handler = 0;
				Enemies[Curr].Anim = UpsideDown;//NoAutoAnim;//AnimByDir;//AnimByFrame2Step;////
				Enemies[Curr].Sprite = 180;
			break;
			
			// Handler 1
			case Enemy1:
				Enemies[Curr].Sprite = 36;
			break;
			case Enemy2:
				Enemies[Curr].Sprite = 38;
			break;
			case Enemy3:
				Enemies[Curr].Sprite = 40;
				Enemies[Curr].Anim = AnimByDir;
			break;
			case Enemy4:
				Enemies[Curr].Sprite = 42;
			break;
			case Enemy21:
				Enemies[Curr].Sprite = 99;
				Enemies[Curr].Anim = AnimByFrame2Step;
			break;
			case Enemy22:
				Enemies[Curr].Sprite = 113;
				Enemies[Curr].Anim = AnimByFrame2Step;
			break;
			case Enemy24:
				Enemies[Curr].Sprite = 132;
				Enemies[Curr].Anim = AnimByDir;
				Enemies[Curr].Y += 8;
			break;
			// End of Handler 1
			case Enemy6:
			case Enemy12:
				Enemies[Curr].Height = 18;
				Enemies[Curr].Data0 = 0;
				Enemies[Curr].Data1 = 9;
				Enemies[Curr].Life = 30;
				Enemies[Curr].Dir = -1;
				Enemies[Curr].Handler = 3;
				Enemies[Curr].TypeAttrib = 0b0000000000000100;// Missile
				Enemies[Curr].Anim = AnimByFrame2Step;
				switch(Model){
					case Enemy6:
						Enemies[Curr].Sprite = 45;
					break;
					case Enemy12:
						Enemies[Curr].Sprite = 65;						
					break;
				}	
			break;			
			case Enemy5:
				Enemies[Curr].Handler = 2;
				Enemies[Curr].Sprite = 44;
				Enemies[Curr].Data1 = Enemies[Curr].Y;
				Enemies[Curr].TypeAttrib = 0b0000000000000010;// Energy
				Enemies[Curr].Anim = NoAutoAnim;
			break;
			case Enemy7:
				Enemies[Curr].Handler = 4;
				Enemies[Curr].Sprite = 47;
				Enemies[Curr].Life = 30;
				Enemies[Curr].TypeAttrib = 0b0000000000000010;// Energy
				Enemies[Curr].Anim = NoAutoAnim;
//				Enemies[Curr].Data3 = 0;
			break;
			case Enemy11:
			case Enemy14:
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 6;
				Enemies[Curr].Data1 = Enemies[Curr].X;
				Enemies[Curr].Anim = AnimByDirAndFrame2Step;
				Enemies[Curr].TypeAttrib = 0b0000000000000010;// Energy
				switch(Model){
					case Enemy11:Enemies[Curr].Sprite = 61;
					break;
					case Enemy14:
						Enemies[Curr].Data3 = Enemies[Curr].Sprite = 128;
						Enemies[Curr].Anim = AnimByDir;
					break;
				};
			break;			
			case Enemy15:
				Enemies[Curr].Sprite = 95;
				Enemies[Curr].Dir = -1;
				Enemies[Curr].Height = 16;
				Enemies[Curr].TypeAttrib = 0b0000000000000100;// Missile
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 7;
				Enemies[Curr].Data0 = 0;
				Enemies[Curr].Data1 = 0;
				Enemies[Curr].Data2 = 0;				
				Enemies[Curr].Anim = NoAutoAnim;//AnimByDir;
				
			break;
			case Enemy16:
				Enemies[Curr].Sprite = 107;
				Enemies[Curr].Dir = -2;
				
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 8;
				Enemies[Curr].Data0 = 0;
				Enemies[Curr].Data1 = 0;
				Enemies[Curr].Data2 = 0;
				Enemies[Curr].TypeAttrib = 0b0000000000000010;// Energy
				Enemies[Curr].Anim = NoAutoAnim;//AnimByDir;
			break;
			case Enemy17:
				Enemies[Curr].Dir = B1;
				Enemies[Curr].Sprite = (Enemies[Curr].Dir<0?101:104);//101-4;
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 9;
				Enemies[Curr].Data0 = 0;
				Enemies[Curr].Data1 = 0;
				Enemies[Curr].Data2 = 0;
				//Enemies[Curr].TypeAttrib = 0b0000000000000000;// Nothing
				Enemies[Curr].Anim = NoAutoAnim;//AnimByDir;
				Enemies[Curr].Y += 3;
				L = 4;
			break;
			case Metroid1:
				Enemies[Curr].Dir = 1;
				Enemies[Curr].Sprite = 119;
				Enemies[Curr].Life = 5;
				Enemies[Curr].Handler = 10;
				Enemies[Curr].TypeAttrib = 0b0000000000000001;// Metroid			
				Enemies[Curr].Anim = AnimByFrame2Step;				
			break;
			case Metroid2:
				Enemies[Curr].Dir = -1;
				Enemies[Curr].Sprite = 121;
				Enemies[Curr].Life = 10;				
				Enemies[Curr].Handler = 10;
				Enemies[Curr].TypeAttrib = 0b0000000000000001;// Metroid
				Enemies[Curr].Anim = AnimByDir;				
			break;
			case Metroid3:
				Enemies[Curr].Dir = -1;
				Enemies[Curr].Sprite = 124;
				Enemies[Curr].Life = 15;				
				Enemies[Curr].Handler = 11;
				Enemies[Curr].TypeAttrib = 0b0000000000000001;// Metroid
				Enemies[Curr].Anim = AnimByDir;				
			break;
			case Enemy18:				
			case Enemy19:
			case Enemy20:
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 5;
				Enemies[Curr].Dir 	= CrawlerStartValues[(short)B1][0];
				Enemies[Curr].Data0 = CrawlerStartValues[(short)B1][1];
				Enemies[Curr].Data1 = CrawlerStartValues[(short)B1][2];
				Enemies[Curr].Data2 = CrawlerStartValues[(short)B1][3];
				Enemies[Curr].TypeAttrib = 0b0000000000000010;// Energy
								
				switch(Model){
					case Enemy18:	
						//Enemies[Curr].Data3 = 0;
						Enemies[Curr].Sprite = 59;
						Enemies[Curr].Anim = AnimByFrame2Step;
					break;			
					case Enemy19:
						Enemies[Curr].Data3 = Enemies[Curr].Sprite = 51;
						Enemies[Curr].Anim = AnimByDir;
					break;
					case Enemy20:
						Enemies[Curr].Data3 = Enemies[Curr].Sprite = 55;
						Enemies[Curr].Anim = AnimByDir;
					break;
				};
				
				L = 4;
				
			break;
						
			case Enemy23:
				Enemies[Curr].Sprite = 134;
				Enemies[Curr].Dir = -1;				
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 12;
				Enemies[Curr].Data0 = 0;
				Enemies[Curr].Data1 = 0;
				Enemies[Curr].Data2 = 0;
				Enemies[Curr].Data3 = 0;
				Enemies[Curr].Height = 20;
				Enemies[Curr].TypeAttrib = 0b0000000000000100;// Missile
				Enemies[Curr].Anim = NoAutoAnim;//AnimByDir;
			break;
			case Enemy25:
				Enemies[Curr].Sprite = 136;
				Enemies[Curr].Dir = -1;				
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 14;
				Enemies[Curr].Data0 = Enemies[Curr].Data1 = 16*B1;
				//Enemies[Curr].Height = 20;
				Enemies[Curr].TypeAttrib = 0b0000000000000100;// Missile
				Enemies[Curr].Anim = AnimByFrame2Step;
				L = 4;
			break;
			case Enemy26:
				Enemies[Curr].Sprite = 143;
				Enemies[Curr].Dir = -1;				
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 13;
				Enemies[Curr].Data0 = Enemies[Curr].Data1 = 16*B1;
				Enemies[Curr].TypeAttrib = 0b0000000000000100;// Missile
				//Enemies[Curr].Height = 20;
				Enemies[Curr].Anim = AnimByFrame3Step;
				L = 4;
			break;
			case Enemy27:				
					
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 15;
				Enemies[Curr].Anim = AnimByFrame2Step;
				Enemies[Curr].TypeAttrib = 0b0000000000000100;// Missile
				
				switch(B1){
					case ScorpUp:
						Enemies[Curr].Data1 = -1;	
						Enemies[Curr].Sprite = 154;
						Enemies[Curr].Y += 4;
					break;
					case ScorpDown:
						Enemies[Curr].Data1 = 1;	
						Enemies[Curr].Sprite = 154;
						Enemies[Curr].Anim = AnimByFrame2StepAndUpsideDown;
						Enemies[Curr].Y += 4;
					break;
					case ScorpLeft:
						Enemies[Curr].Dir = -1;	
						Enemies[Curr].Sprite = 150;
					break;
					case ScorpRight:
						Enemies[Curr].Dir = 1;	
						Enemies[Curr].Sprite = 152;
					break;
				};
	
			break;
			case Enemy28:
				Enemies[Curr].Sprite = 162;
				//Enemies[Curr].Dir = 0;				
				Enemies[Curr].Life = 20;
				Enemies[Curr].Handler = 16;
				Enemies[Curr].Data1 = 0;
				Enemies[Curr].TypeAttrib = 0b0000000000000010;// Energy
				Enemies[Curr].Anim = AnimByDir;
			break;
			case Enemy29:
				Enemies[Curr].Data0 = Enemies[Curr].Data1 = B1;//shoot
				Enemies[Curr].Data3 = B2;//block
				Enemies[Curr].Data2 = 1;
				Enemies[Curr].Handler = 17;
				Enemies[Curr].Life = 20;
				Enemies[Curr].TypeAttrib = 0b0000000000010000;// Immortal
				L = 5;
			break;
			case Enemy30:
				Enemies[Curr].Dir = 1;
				Enemies[Curr].Anim = AnimByDirAndFrame2Step;
				Enemies[Curr].Sprite = 156;
				Enemies[Curr].Handler = 18;
				Enemies[Curr].Life = 20;
				Enemies[Curr].TypeAttrib = 0b0000000000000010;// Energy
			break;
			case Enemy31:
				Enemies[Curr].Handler = 4;
				Enemies[Curr].Sprite = 168;
				Enemies[Curr].Life = 30;
				Enemies[Curr].Anim = NoAutoAnim;
				Enemies[Curr].TypeAttrib = 0b0000000000000100;
				Enemies[Curr].Data3 = 168;
				//Enemies[Curr].Y -= 16;
			break;
			case Enemy32:
				Enemies[Curr].Handler = 19;
				Enemies[Curr].Sprite = 179;
				Enemies[Curr].Life = 20;
				Enemies[Curr].Anim = NoAutoAnim;
				Enemies[Curr].TypeAttrib = 0b0000000000000010;
				Enemies[Curr].Y -= 9;
			break;
			case Enemy33:
				Enemies[Curr].Handler = 20;
				Enemies[Curr].Sprite = 180;
				Enemies[Curr].Life = 10;
				Enemies[Curr].Anim = NoAutoAnim;
				Enemies[Curr].Data1 = Enemies[Curr].X;
				Enemies[Curr].Data2 = Enemies[Curr].Y;
				Enemies[Curr].Data3 = 50;
				Enemies[Curr].TypeAttrib = 0b0000000000001000;
			break;
			
			
			
			
		}
		
		Raw += L;
		
	}
	
};*/
/*
void LoadItems(char* Raw){
	
	// Test code	
	
	if( (Items = malloc(Room->NrOfItems*sizeof(item)))==NULL ){
		Room->NrOfItems = 0;
		return;		
	};
	
	// End of test code	
	
	
	short C;	
	
	for(C=0;C<Room->NrOfItems;C++){
				
		Items[C].Type = (*(Raw));
		Items[C].X = (*(Raw+1))*16;
		Items[C].Y = (*(Raw+2))*16;
		Items[C].Active = 1;
		
		Raw += 3;
	};
	
	
	
};
*/