#ifndef __items__
#define __items__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   items.h                                                               *
*			Description:        																							            *
*			This file contains definitions, variables and functions used to handle all 		*
*			Items in the game. The items are all kinds of power-ups, like energy tanks		*
*			weapon upgrades etc. 																													*
*			Additionaly, the lift at the game ending is implemented as an item						*
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

typedef struct{
	short X;
	short Y;
	
	short Active;
	short Type;// Indicates type as sprite nr
						 // All are animated by frame 2 step
	
	short Event; // Holds index in event array
	
}item;


extern item* Items;


enum ItemTypes_ { // Indicates Power-up type and sprite
	missile_pod_pu=72, energy_tank_pu=74, energy_ball_pu=76, 
	spring_ball_pu=78, high_jump_pu=80, wave_beam_pu=82, 
	ice_beam_pu=84, bomb_pu=86, missile_battery_pu=197,
	spider_ball_pu=185, space_jump_pu=187, screw_attack_pu=189,
	varia_Suit_pu=191, spazer_beam_pu=193, plasma_beam_pu=195,
	game_end=265,
};


void HandleItems();

void DoPickUpPrompt(short Id);



#endif