#ifndef __all__
#define __all__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   all.h                                                                 *
*			Description:  Includes all header files used in the project.                  *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/



/* Uncomment the calculator model you want to compile for.
   Do one calc model at the time.
   TI89 == TI89 && TI89Titanium */
//#define MakeTI89
//#define MakeTI92Plus
#define MakeV200

/*  
SpeedTest enables a speed indicator on the statusbar. It doesn't give any accurate FPS,
but a shallow indication. It is useful when changes that may have moderate/big impact on 
game speed has been done.
*/
//#define SpeedTest

// Enable watchdog. Will catch infinite loops
//#define watchdog

//immortal macro gives immortal mode. For testing
//#define immortal

//#define missile_unlimited 

//#define small_delay


// Compile demo1 setup: Area 3+ not available
//#define demo1
// Compile demo2 setup: Area 5+ not available
//#define demo2

//#define freeze

// SpeedAdjust enables adjustable speed. 
#define SpeedAdjust



#ifdef demo1
#define small_delay
#endif
#ifdef demo2
#define small_delay
#endif



#include <tigcclib.h>
#include "TileMap.h"
#include "extgraph.h"
#include "GFX.h"
#include "error.h"
#include "render.h"
#include "player.h"
#include "tiletools.h"
#include "fileutil.h"
#include "playloop.h"
#include "scankeys.h"
#include "gamestate.h"
#include "level.h"
#include "enemies.h"
#include "items.h"
#include "fastitoa.h"
#include "TestCollideX82w2h_invsprts_R.h"
#include "events.h"
#include "savegame.h"
#include "blocking.h"
#include "titlescreen.h"
#include "watchdog.h"
#include "object.h"
#include "minimap.h"
#include "brieflz.h"
#include "menus.h"
#include "starfield.h"


//#include "testmaps.h"


#endif