/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   Metroid.c                                                             *
*			Description:  Contains the _main() function.   								                *
*                                                                                   *
*                                                                                   *
*                                                                                   *
************************************************************************************/

#include "all.h"


#ifdef SpeedTest
#warning "Speed test enabled"
// Speedtest:
// Note: This does NOT give an accurate FPS, probably not even close to.
// It measures the number of frames within 255 ticks of AUTO_INT_1 (when grayscale is enabled.)
// It was used to give an indication of how effective frame skipping and increasing animation length was as a speed optimization.
// Those optimizations were aimed on Voyage 200 and Ti-92+ because the game run slower on those calcs.

volatile short Fps;
volatile char Counter;
volatile short UpdateFrameCounter;

DEFINE_INT_HANDLER (TESTCOUNTER) {//speed test
    Counter++;
    if(Counter==0){
    	UpdateFrameCounter = Fps;
    	Fps = 0; 
    }
}
#endif

#ifdef SpeedAdjust
DEFINE_INT_HANDLER (SPEEDCOUNTER) {//speed test
    
    Gamestate.SpeedCounter++;
    
}
#endif

#ifdef watchdog

void _main(void);

DEFINE_INT_HANDLER (WATCHDOG) {
  if(WatchDog.Enable){
  	WatchDog.Counter++;
	  if(WatchDog.Counter==0){
    	if(WatchDog.FrameId==WatchDog.PrevFrameId){
    		// Hang detected!
    		WatchDog.Alarm = 1;
    		WatchDog.Enable = 0;
    		//WDDisp();
    		while(_rowread(0));
    		_main();	
    	};
    	WatchDog.PrevFrameId = WatchDog.FrameId;
	  };
  };
  
}

#endif

INT_HANDLER ai1,ai5;
void* Block;

void _main(void)
{
	#ifdef watchdog
		if(WatchDog.Alarm){
			goto Quit;
		};
	#endif
	
	//redirecting auto-int 1 and 5
	
	ai1 = GetIntVec(AUTO_INT_1);
	ai5 = GetIntVec(AUTO_INT_5);
	SetIntVec(AUTO_INT_5,DUMMY_HANDLER);
		
	#ifdef SpeedTest
	SetIntVec(AUTO_INT_1,TESTCOUNTER);
	#endif
	#ifndef SpeedTest
	SetIntVec(AUTO_INT_1,DUMMY_HANDLER);
	#endif
	#ifdef SpeedAdjust
	SetIntVec(AUTO_INT_1,SPEEDCOUNTER);
	#endif
	#ifdef watchdog
	SetIntVec(AUTO_INT_1,WATCHDOG);
	#endif
	
	Exit = 0;
	ErrorCode = 0;	
	
	if(!GrayOn())	
	{
		ErrorCode = 2;//Grayscale failed
		goto Quit;
	};
	
	/*void**/ Block = NULL;
			
	Block = malloc( (unsigned long) (GRAYDBUFFER_SIZE + GRAY_BIG_VSCREEN_SIZE + (GRAY_BIG_VSCREEN_SIZE-scrollbuffersize) + 480 + TotalNrOfRooms*sizeof(char)) );
	
	if(Block==NULL){
		ErrorCode = 1;//Out of memory
		goto Quit;
	}
	
	GrayDBufInit (Block);//Initialize TIGCC double buffering
	
	InitializeTilemap();
	FgPlane.p.big_vscreen = Block + GRAYDBUFFER_SIZE;
	
	StatBar = Block + GRAYDBUFFER_SIZE + GRAY_BIG_VSCREEN_SIZE + scrollbuffersize;
	
	VisitedRooms = StatBar + 480;
		
	randomize();	
	
	if((ErrorCode = Load_GFX())){
		//GFX file(s) not found
		goto Quit;
	};
	
	if( (ErrorCode = InitMapfilePointer()) ){
		goto Quit;
	};
		
	LoadConfig();
	
	// Launch the game itself:
	Menus();	
		
			
	Quit:
	/*
	#ifdef watchdog
		if(WatchDog.Alarm){
			WDDisp();
		};
	#endif
	*/
	#ifdef demo1
		DisplayEndOFDemo(Exit);
	#endif	
	#ifdef demo2
		DisplayEndOFDemo(Exit);
	#endif	
		
	
	GrayOff();
		
	//unlock memblocks used by external files
	HeapUnlock( Tilefile_sym_h );
	HeapUnlock( Spritefile_sym_h );
	HeapUnlock( Mapfile_sym_h );
		
	SetIntVec(AUTO_INT_5,ai5);
	SetIntVec(AUTO_INT_1,ai1);	
	
	if(Block)
		free(Block);
	if(LevelArray)
		free(LevelArray);
	if(AreaArray)
		free(AreaArray);
	if(EventArray)
		free(EventArray);	
	
	if(ErrorCode){
		DispErrorMsg(ErrorCode);
	};
	
	#ifdef watchdog
		if(WatchDog.Alarm){
			WDDisp();	
			exit(0);
		};	
	#endif
	
	GKeyFlush();	
	
}
