#ifndef __GFX__
#define __GFX__

/************************************************************************************
*                                                                                   *
*                                                                                   *
*			Metroid 68K                                                                   *
*			by Lachprog   																																*
*     Compatible with Ti-89, Ti-89 Titanium, Ti-92+ and Voyage 200 Calculators.			*                                                           *
*			Distributed under the GNU Licence.																						*
*																																										*
*     Email: lachprog@hotmail.com                                                   *
*     Project page: http://tifreakware.net/lachprog/                                *
*                                                                                   *
*                                                                                   *
*			File:   GFX.h                                                                 *
*			Description:          																							          *
*     This file contains functions, constants and variables/pointers used to				*
*			access the game graphics (GFX) that is stored in external files.							*                                                                           *
*    	The graphics files are:																												*
*			-metrotil.GFX:  All tile data																									*
*     -metrospr.GFX   All sprite data (All GFX that is not tiles										*
*			 (The title screen GFX is kept in metromap.tta)																*
*                                                                                   *
*                                                                                   *
************************************************************************************/

#define total_size_of_long_sprites	7910
//7886
//7790
//7754
//7619
//7574
//7574
//5030
//4916
//3812
//3707
//3521
//3329
//3029
//2696
//2147
//1907
//1835
//1803
//1650
//1548
//1410

#define blank_spr	(Sprites32+1803)
#define blank_spr32_offset 1803

#define blank_spr16	(Sprites16+3658)
#define blank_spr16_offset 3658

/*
typedef struct{
	unsigned short Offset;
	short Height;
	short Xoff;
	short Yoff;
	short DrawMode;
}sprite;
*/
typedef struct{
	unsigned short Offset;
	char Height;
	char Xoff;
	char Yoff;
	char DrawMode;
}sprite;

enum SpriteDrawModes {
	width16=0,width32=1,width16_ball=2,width48=3,
};


extern HANDLE Tilefile_sym_h, Spritefile_sym_h;

extern unsigned long* Sprites32;
extern unsigned short* Sprites16;

extern sprite SpriteTab[270];

//Finds all GFX files and sets up pointers to the data blocks
short Load_GFX();










#endif