/* Decompresses an image that has been compressed with vertical RLE
 *
 * Paramenters:
 *   src = array of compressed data (pointer)
 *   dest = will become uncompressed array (pointer)
 *   size = size of decompressed data array
 *  src and dest need to be allocated before calling
 *  size needs to be initialized before calling
 *  change BYTES_PER_ROW and NUM_ROWS if needed
 */

#include "all.h"

#define SENTINEL_VALUE 0x91
#define BYTES_PER_ROW 30

#ifndef PRODUCE_TI89_CODE
#define NUM_ROWS 128
#endif

#ifdef PRODUCE_TI89_CODE
#define NUM_ROWS 100
#endif

void DecompRLEVert(unsigned char *src, unsigned char *dest, int size)
{
	int i = 0, j;
	int pos = 0;
	int dcmpNum = 0;
	
	while (dcmpNum < size)
	{
		//decompress a run
		if (src[i] == SENTINEL_VALUE)
		{
			i++;
			for(j = 0; j < src[i + 1]; j++)
			{
				dest[pos] = src[i];
				pos += BYTES_PER_ROW;
				if (pos >= BYTES_PER_ROW * NUM_ROWS)
				{
					pos -= BYTES_PER_ROW * NUM_ROWS;
					pos++;
				}
			}
			i++;
			dcmpNum += src[i];
		}
		else
		{
			dest[pos] = src[i];
			pos += BYTES_PER_ROW;
			if (pos >= BYTES_PER_ROW * NUM_ROWS)
			{
				pos -= BYTES_PER_ROW * NUM_ROWS;
				pos++;
			}
			dcmpNum++;
		}
		i++;
	}
}
