#ifndef __tiles__
#define __tiles__

#ifndef PRODUCE_TI89_CODE

#define TileDim					16

#endif

#ifdef PRODUCE_TI89_CODE

#define TileDim					12

#endif





#define SlideSpeed			2

#define TileWallLow			30

#define TileWallHigh		31

#define TileItemLow			12

#define TileItemHigh		21	

#define TileSolidLow		30

#define TileArrowLow		22
#define TileArrowHigh		29

#define TileArrDnLow		28
#define TileArrDnHigh		29

#define TileArrLeLow		22
#define TileArrLeHigh		23

#define TileArrUpLow		26
#define TileArrUpHigh		27

#define TileArrRiLow		24
#define TileArrRiHigh		25


#define NrOfItemTiles		10



#ifdef PRODUCE_TI89_CODE
// TI 89 Tiles:
// X
#define Item1Spr  {0xBFD0,0x3FC0,0xDFB0,0xEF70,0xF6F0,0xF9F0,0xF9F0,0xF6F0,0xEF70,0xDFB0,0x3FC0,0xBFD0,0xDFB0,0xCF30,0x0600,0x8010,0xC030,0xE070,0xE070,0xC030,0x8010,0x0600,0xCF30,0xDFB0}

#define Item2Spr  {0xFBF0,0xD570,0xA0B0,0x8030,0x3190,0x3190,0xA0B0,0xC0F0,0xF5F0,0xF1F0,0xF1F0,0xF1F0,0xFFF0,0xFBF0,0xDB70,0xDB70,0x9B30,0x9B30,0xC070,0xFFF0,0xFBF0,0xFBF0,0xFBF0,0xFBF0}
//Darker
#define Item3Spr  {0xF0F0,0xE670,0xF6F0,0xE670,0xF0F0,0xFBF0,0x9F10,0x9F10,0xFBF0,0xFAF0,0xFBF0,0xF470,0xF9F0,0xF6F0,0xE670,0xF6F0,0xF9F0,0xDDB0,0xC430,0xC430,0xDDB0,0xFDF0,0xFCF0,0xF870}
// Lighter
//#define Item3Spr  {0xF9F0,0xF6F0,0xF6F0,0xF6F0,0xF9F0,0xFBF0,0x9F10,0x9F10,0xFBF0,0xFAF0,0xFBF0,0xF470,0xF0F0,0xE670,0xE670,0xE670,0xF0F0,0xDDB0,0xC430,0xC430,0xDDB0,0xFDF0,0xFCF0,0xF870}

#define Item4Spr  {0x39C0,0x0F00,0xB9D0,0xB9D0,0xF6F0,0x4920,0x4920,0xF6F0,0xB9D0,0xB9D0,0x0F00,0x39C0,0xFFF0,0x9990,0xB9D0,0xEF70,0xF9F0,0x9090,0x9090,0xF9F0,0xEF70,0xB9D0,0x9990,0xFFF0}
// Cross
#define Item5Spr  {0xE970,0xE970,0xE970,0x0900,0xF9F0,0x0000,0x0000,0xF9F0,0x0900,0xE970,0xE970,0xE970,0xF0F0,0xF0F0,0xF0F0,0xF0F0,0x0000,0x0000,0x0000,0x0000,0xF0F0,0xF0F0,0xF0F0,0xF0F0}

#define Item6Spr  {0x2640,0x5FA0,0xBFD0,0x79E0,0x7FE0,0xE970,0xE970,0x7FE0,0x79E0,0xBFD0,0x5FA0,0x2640,0x1F80,0x3FC0,0x7FE0,0xFFF0,0xF0F0,0xF0F0,0xF0F0,0xF0F0,0xFFF0,0x7FE0,0x3FC0,0x1F80}

#define Item7Spr  {0xFFF0,0xFFF0,0xFFF0,0xFDF0,0xF6F0,0xE9F0,0xF970,0xF6F0,0xFBF0,0xFFF0,0xFFF0,0xFFF0,0xFDF0,0xFBF0,0xFBF0,0xFBF0,0xF9F0,0x7010,0x80E0,0xF9F0,0xFDF0,0xFDF0,0xFDF0,0xFBF0}
// Sun
#define Item8Spr  {0x7BE0,0xFBF0,0xF9F0,0xF0F0,0xE670,0xC100,0x0930,0xE670,0xF0F0,0xF9F0,0xFDF0,0x7DE0,0xFFF0,0xBFD0,0xDFB0,0xFFF0,0xF9F0,0xFEF0,0xF6F0,0xF9F0,0xFFF0,0xDFB0,0xBFD0,0xFFF0}

#define Item9Spr  {0xFDF0,0xFDF0,0xD8F0,0xF0F0,0xE530,0x8000,0xE530,0xF0F0,0xD8F0,0xFDF0,0xFDF0,0xFFF0,0xFDF0,0xBDE0,0xDAD0,0xFF70,0xE8B0,0x88C0,0xECB0,0xFF70,0xD8D0,0xBDE0,0xFDF0,0xFFF0}

#define Item10Spr  {0xFFF0,0xFCE0,0xF770,0xCB70,0xC510,0xE8E0,0xD510,0xC270,0xE070,0xB3F0,0x1FF0,0xBFF0,0xFFE0,0xF2C0,0xE8E0,0xF4B0,0xBAD0,0x1700,0xA8D0,0xFDB0,0xFFF0,0xFCF0,0xBFF0,0xFFF0}

#define Item11Spr  {}

#define Item12Spr  {}



#define WallTile1		{0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xFFE0,0x8000,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFF0}

#define WallTile2		{0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xFFE0,0x8000,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFF0}

// Down
#define ArrowTile1	{0x0000,0x8000,0x8880,0x8900,0x8800,0x8880,0x8900,0x8A00,0x8400,0x8800,0x8000,0xFFE0,0x8000,0xFFE0,0xF9E0,0xF960,0xF860,0xF8E0,0xF960,0xFAE0,0xFDE0,0xFBE0,0xFFE0,0xFFF0}
// Left
#define ArrowTile2	{0x0000,0x8000,0x8000,0x8240,0x8480,0x8800,0x9000,0xAFC0,0x8000,0x8000,0x8000,0xFFE0,0x8000,0xFFE0,0xFFE0,0xFA60,0xF4E0,0xE820,0xD020,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFF0}
// Up
#define ArrowTile3	{0x0000,0x8000,0x8800,0x8400,0x8A00,0x8900,0x8880,0x8800,0x8900,0x8880,0x8000,0xFFE0,0x8000,0xFFE0,0xFBE0,0xFDE0,0xFAE0,0xF960,0xF8E0,0xF860,0xF960,0xF9E0,0xFFE0,0xFFF0}
// Right
#define ArrowTile4	{0x0000,0x8000,0x8000,0xA400,0x9200,0x8100,0x8080,0xBF40,0x8000,0x8000,0x8000,0xFFE0,0x8000,0xFFE0,0xFFE0,0xE5E0,0xF2E0,0xC160,0xC0A0,0xFFE0,0xFFE0,0xFFE0,0xFFE0,0xFFF0}

// Down
#define Arrow2Tile1	{0x0000,0x8E00,0x8E00,0x8000,0x8000,0x8E00,0x9F00,0x8E00,0x8400,0x8000,0x8000,0xFFE0,0x8000,0xE0E0,0xE0E0,0xEEE0,0xEEE0,0xEEE0,0xDF60,0xEEE0,0xF5E0,0xFBE0,0xFFE0,0xFFF0}
// Left
#define Arrow2Tile2	{0x0000,0x8000,0x8000,0x8400,0x8E60,0x9E60,0x8E60,0x8400,0x8000,0x8000,0x8000,0xFFE0,0x8000,0xFFE0,0xFBE0,0xF400,0xEF80,0xDF80,0xEF80,0xF400,0xFBE0,0xFFE0,0xFFE0,0xFFF0}
// Up
#define Arrow2Tile3	{0x0000,0x8000,0x8000,0x8400,0x8E00,0x9F00,0x8E00,0x8000,0x8000,0x8E00,0x8E00,0xFFE0,0x8000,0xFFE0,0xFBE0,0xF5E0,0xEEE0,0xDF60,0xEEE0,0xEEE0,0xEEE0,0xE0E0,0xE0E0,0xFFF0}
// Right
#define Arrow2Tile4	{0x0000,0x8000,0x8000,0x8200,0xE700,0xE780,0xE700,0x8200,0x8000,0x8000,0x8000,0xFFE0,0x8000,0xFFE0,0xFDE0,0x82E0,0x9F60,0x9FA0,0x9F60,0x82E0,0xFDE0,0xFFE0,0xFFE0,0xFFF0}




#define BlackTile		{0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0}



#define PuzzleTile1	{0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xC630,0x9090,0x2040,0x30C0,0x1F80,0x8010,0xC030,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xF9F0,0xE070,0xC030,0xC030,0xE070,0xFFF0,0xFFF0}

#define PuzzleTile2	{0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xC030,0x8F10,0x1F80,0x0F00,0x0000,0x8010,0xC030,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xF0F0,0xE070,0xF0F0,0xFFF0,0xFFF0,0xFFF0}

#define NextLevTile1	{0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFF80,0xFF30,0xFCF0,0xF9F0,0xF3F0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFC0,0xFF00,0xFE00,0xFC00}

#define NextLevTile2	{0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0x8010,0xFFE0,0xFFF0,0xFC00,0xE3F0,0x9EF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0x0010,0x0000,0x03F0,0x1FF0,0x7F00}

#define NextLevTile3	{0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0x7FF0,0x9FF0,0x6FF0,0x97F0,0x63F0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0x7FF0,0x9FF0,0xEFF0,0xFFF0}

#define NextLevTile4	{0xE7E0,0xCFC0,0x9F90,0xBF30,0x7F70,0x7F60,0x7F60,0x7F70,0x7F70,0x3F30,0xBF90,0x9FC0,0xF810,0xF030,0xE070,0xC0F0,0x80F0,0x80F0,0x80F0,0x80F0,0x80F0,0xC0F0,0xC070,0xE030}

#define NextLevTile5	{0x7790,0xFC00,0xB000,0x6000,0xC000,0x8000,0x8000,0xC000,0x6000,0xB000,0xDC00,0xF790,0xF860,0xE300,0xCC00,0x9000,0x2000,0x4000,0x4000,0x2000,0x9000,0xCC00,0xE300,0xF860}

//#define NextLevTile6	{0x0DF0,0x07F0,0xC3F0,0xF0F0,0xF8F0,0xFC70,0xFC50,0xF8D0,0xF080,0xC380,0x0700,0x0E00,0xFFF0,0xFFF0,0x3FF0,0x0FF0,0x07F0,0x03F0,0x03F0,0x07F0,0x0FF0,0x3FF0,0xFFF0,0xFFF0}
//#define NextLevTile6	{0x0DF0,0x37F0,0x0BF0,0x04F0,0x02F0,0x0170,0x0150,0x02D0,0x0480,0x0B80,0x3700,0x0E00,0xFFF0,0xCFF0,0x37F0,0x0BF0,0x05F0,0x02F0,0x02F0,0x05F0,0x0BF0,0x37F0,0xCFF0,0xFFF0}
//#define NextLevTile6	{0x6DF0,0x37F0,0x0BF0,0x04F0,0x02F0,0x0170,0x0150,0x02D0,0x0480,0x0B80,0x3720,0x6E60,0x9FF0,0x4FF0,0x37F0,0x0BF0,0x05F0,0x02F0,0x02F0,0x05F0,0x0BF0,0x37F0,0x4FD0,0x9F90}
#define NextLevTile6	{0xEDF0,0x37F0,0x0BF0,0x04F0,0x02F0,0x0170,0x0150,0x02D0,0x0480,0x0B80,0x3720,0xEE60,0x1FF0,0xCFF0,0x37F0,0x0BF0,0x05F0,0x02F0,0x02F0,0x05F0,0x0BF0,0x37F0,0xCFD0,0x1F90}



#define NextLevTile7	{0xDFE0,0xEFF0,0xE7F0,0xF3F0,0xF9F0,0xFC70,0xFF10,0xFFC0,0xFFE0,0xFFF0,0xFFF0,0xFFF0,0xE010,0xF000,0xF800,0xFC00,0xFE00,0xFF80,0xFFE0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0}

#define NextLevTile8	{0x7EF0,0x9FF0,0xE0F0,0xFC00,0xFFF0,0xFFF0,0xFFF0,0xFFC0,0x0010,0xFFF0,0xFFF0,0xFFF0,0xFF00,0x7FF0,0x1FF0,0x03F0,0x0000,0x0000,0x0000,0x0030,0xFFF0,0xFFF0,0xFFF0,0xFFF0}

#define NextLevTile9	{0x7CD0,0xF3D0,0x8FB0,0x7E70,0xFCF0,0xF3F0,0x8FF0,0x7FF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFF30,0xFC30,0xF070,0x81F0,0x03F0,0x0FF0,0x7FF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0,0xFFF0}




unsigned short Tiles[][32] = {
	BlackTile,
	
	PuzzleTile1,
	PuzzleTile2,
	
	NextLevTile1,
	NextLevTile2,
	NextLevTile3,
	NextLevTile4,
	NextLevTile5,
	NextLevTile6,
	NextLevTile7,
	NextLevTile8,
	NextLevTile9,
	
	Item1Spr,
	Item2Spr,
	Item3Spr,
	Item4Spr,
	Item5Spr,
	Item6Spr,
	Item7Spr,
	Item8Spr,
	Item9Spr,
	Item10Spr,
		
	ArrowTile2,
	Arrow2Tile2,
	ArrowTile4,
	Arrow2Tile4,
	ArrowTile3,
	Arrow2Tile3,
	ArrowTile1,	
	Arrow2Tile1,
	
	WallTile1,
	WallTile2,
	

	
};



#endif


#ifndef PRODUCE_TI89_CODE

// Ti 92+ and Voyage 200 Tiles

// Eagle body
#define Item1Spr  {0xCFA1,0x034E,0x7881,0xBC01,0x467B,0xF4E7,0xE9F7,0xD3F7,0xA7E7,0x57F1,0x25B2,0x2411,0x2224,0x2630,0x2C4D,0x58B2,0xFFC0,0xCF81,0x2303,0x401F,0xF807,0xF81F,0xF00F,0xE00F,0xC01F,0x8007,0x8A49,0x8BE4,0x8F7A,0x8F7A,0x9EB2,0xBD7F}

#define Item2Spr  {0xFDFF,0xF68F,0xED03,0xDD97,0xDE49,0xBE01,0xA60C,0xE218,0xB237,0xBE36,0x1A37,0x5A1B,0xAA07,0x5A01,0xAB01,0xEBC5,0xFE07,0xF803,0xF001,0xE061,0xE030,0xC000,0xD000,0x9006,0x880E,0x800F,0xC00F,0xA007,0x4001,0x2000,0x1000,0x9003}

#define Item3Spr  {0xFA5F,0xF50F,0xFBAF,0xFBAF,0xFFBF,0xF54F,0xFA3F,0xFD7F,0x9B4B,0x9B2B,0xFD77,0xFD7F,0xFD7F,0xFD3F,0xFD7F,0xFA1F,0xFC3F,0xF99F,0xF3CF,0xF3CF,0xF3CF,0xF99F,0xFC1F,0xDE3B,0xC603,0xC643,0xDE7B,0xFE7F,0xFE7F,0xFE7F,0xFE3F,0xFC1F}

#define Item4Spr  {0x3E7C,0x13C8,0xBE7D,0xF7F7,0xAE6D,0xBDBD,0xFA5F,0x542A,0x542A,0xFA5F,0xBDBD,0xB675,0xEFEF,0xBE7D,0x13C8,0x3E7C,0xFFFF,0x8E71,0xBE7D,0xA665,0xF7F7,0xFE7F,0xFC3F,0x8811,0x8811,0xFC3F,0xFE7F,0xE7E7,0xB675,0xBE7D,0x8E71,0xFFFF}
// Cross
#define Item5Spr  {0xF24F,0xF24F,0xF24F,0xF24F,0x0240,0x0240,0xFE7F,0x0000,0x0000,0xFE7F,0x0240,0x0240,0xF24F,0xF24F,0xF24F,0xF24F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F}

#define Item6Spr  {0x318C,0x67E6,0xDFFB,0xBFFD,0x3C3C,0x799E,0x73CE,0xF66F,0xF66F,0x73CE,0x799E,0x3C3C,0xBFFD,0xDFFB,0x67E6,0x318C,0x0FF0,0x1FF8,0x3FFC,0x7FFE,0xFFFF,0xFE7F,0xFC3F,0xF81F,0xF81F,0xFC3F,0xFE7F,0xFFFF,0x7FFE,0x3FFC,0x1FF8,0x0FF0}

#define Item7Spr  {0xFFBF,0xFF7F,0xFFFF,0xFFFF,0xFF7F,0xFDFF,0x7E5F,0xB43F,0xFC2D,0xFA7E,0xFFBF,0xFEFF,0xFFFF,0xFFFF,0xFEFF,0xFDFF,0xFF7F,0xFEFF,0xFEFF,0xFEFF,0xFEFF,0xFE7F,0xFC3F,0x7801,0x801E,0xFC3F,0xFE7F,0xFF7F,0xFF7F,0xFF7F,0xFF7F,0xFEFF}

#define Item8Spr  {0xFEFE,0xBEFD,0xDE7F,0xF81F,0xF1CF,0xE067,0xE037,0xC030,0x0833,0xEC77,0xE7E7,0xF3CF,0xF81F,0xFE7B,0xBF7D,0x7F7F,0xFFFF,0xFFFF,0xFFFB,0xEFF7,0xFE3F,0xFF9F,0xFFCF,0xFFCF,0xF7CF,0xF38F,0xF81F,0xFC3F,0xEFF7,0xDFFF,0xFFFF,0xFFFF}

#define Item9Spr  {0xFF7E,0xEFFB,0xD7F5,0xE6B3,0xFC3F,0xF8BF,0xF007,0xE62C,0xF707,0xFBBF,0xFD3F,0xFEBF,0xE7F3,0xD7F5,0xEF7B,0xFFFE,0xBF7E,0xDF7D,0xEE3B,0xF77F,0xFFDF,0xFF4F,0xEF7B,0x9810,0xEF7B,0xFF4F,0xFFDF,0xFF7F,0xF63F,0xEF7B,0xDF7D,0xBFFE}

#define Item10Spr  {0xFFFF,0xFFFD,0xFE5F,0xFBFF,0xE5E7,0xE287,0xC421,0xE00E,0xC021,0xE287,0xE047,0xF01F,0xD8FF,0xAFFF,0xDFFF,0xFFFF,0xFFFD,0xFFF8,0xF99D,0xF40F,0xFA1F,0xDD3B,0xBBDD,0x1FE0,0xBFDD,0xDD3B,0xFFBF,0xFFEF,0xFF1F,0xDFFF,0xFFFF,0xFFFF}

#define Item111Spr  {}

#define Item12Spr  {}




#define WallTile1	{0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFF}

#define WallTile2	{0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFF}


// Down
#define ArrowTile1	{0x0000,0x8000,0x8000,0x8210,0x8220,0x8240,0x8210,0x8220,0x8240,0x8280,0x8100,0x8200,0x8200,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFFFE,0xFE7E,0xFE6E,0xFE4E,0xFE1E,0xFE2E,0xFE4E,0xFE9E,0xFF3E,0xFE7E,0xFEFE,0xFFFE,0xFFFE,0xFFFF}
// Left
#define ArrowTile2	{0x0000,0x8000,0x8000,0x8000,0x8000,0x8048,0x8090,0x8120,0x8200,0x8400,0x9BF8,0x8000,0x8000,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFE4E,0xFC9E,0xF93E,0xF206,0xE406,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFF}
// Up
#define ArrowTile3	{0x0000,0x8000,0x8000,0x8200,0x8200,0x8100,0x8280,0x8240,0x8220,0x8210,0x8240,0x8220,0x8210,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFFFE,0xFEFE,0xFE7E,0xFF3E,0xFE9E,0xFE4E,0xFE2E,0xFE1E,0xFE4E,0xFE6E,0xFE7E,0xFFFE,0xFFFE,0xFFFF}
// Right
#define ArrowTile4	{0x0000,0x8000,0x8000,0x8000,0x8000,0x9200,0x8900,0x8480,0x8040,0x8020,0x9FD8,0x8000,0x8000,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xF27E,0xF93E,0xFC9E,0xE04E,0xE026,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFE,0xFFFF}


// Down
#define Arrow2Tile1	{0x0000,0x8000,0x8000,0x8380,0x8380,0x8000,0x8000,0x8380,0x9FF0,0x8FE0,0x87C0,0x8380,0x8100,0x8000,0x8000,0xFFFE,0x8000,0xF83E,0xF83E,0xF83E,0xF83E,0xFBBE,0xFBBE,0xF39E,0xDFF6,0xEFEE,0xF7DE,0xFBBE,0xFD7E,0xFEFE,0xFFFE,0xFFFF}
// Left
#define Arrow2Tile2	{0x0000,0x8000,0x8000,0x8100,0x8300,0x8700,0x8F98,0x9F98,0x8F98,0x8700,0x8300,0x8100,0x8000,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFEFE,0xFDFE,0xFB7E,0xF700,0xEFE0,0xDFE0,0xEFE0,0xF700,0xFB7E,0xFDFE,0xFEFE,0xFFFE,0xFFFE,0xFFFF}
// Up
#define Arrow2Tile3	{0x0000,0x8000,0x8000,0x8100,0x8380,0x87C0,0x8FE0,0x9FF0,0x8380,0x8000,0x8000,0x8380,0x8380,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFEFE,0xFD7E,0xFBBE,0xF7DE,0xEFEE,0xDFF6,0xF39E,0xFBBE,0xFBBE,0xF83E,0xF83E,0xF83E,0xF83E,0xFFFF}
// Right
#define Arrow2Tile4	{0x0000,0x8000,0x8000,0x8080,0x80C0,0x80E0,0x99F0,0x99F8,0x99F0,0x80E0,0x80C0,0x8080,0x8000,0x8000,0x8000,0xFFFE,0x8000,0xFFFE,0xFF7E,0xFFBE,0xFEDE,0x80EE,0x87F6,0x87FA,0x87F6,0x80EE,0xFEDE,0xFFBE,0xFF7E,0xFFFE,0xFFFE,0xFFFF}



#define BlackTile		{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}



//#define PuzzleTile1	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xE3C7,0x8C31,0x1818,0x3C3C,0x1FF8,0x07E0,0x8001,0xE007,0xFC3F,0xF00F,0xE007,0xC003,0xE007,0xF81F,0xFFFF,0xFFFF}
#define PuzzleTile1	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xE3C7,0x8C31,0x1818,0x3C3C,0x1FF8,0x07E0,0x8001,0xE007,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xF00F,0xE007,0xC003,0xE007,0xF81F,0xFFFF,0xFFFF,0xFFFF}
//#define PuzzleTile2	{0xE3C7,0x83C1,0x07E0,0x03C0,0x0000,0x0000,0x8001,0xE007,0xFC3F,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF}
//#define PuzzleTile2	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3CF,0xC3C3,0x87E1,0x03C0,0x0000,0x8001,0xC003,0xF00F,0xFC3F,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF}
//#define PuzzleTile2	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3CF,0xC3C3,0x87E1,0x03C0,0x0000,0x8001,0xC003,0xF00F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}
#define PuzzleTile2	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xE007,0x83C1,0x07E0,0x03C0,0x0000,0x0000,0x8001,0xE007,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}


//#define PuzzleTile3	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3CF,0xE7E7,0xC3C3,0xE007,0xF81F,0xFFFF,0xFFFF,0xFC3F,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF}
#define PuzzleTile3	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF3CF,0xE7E7,0xC3C3,0xE007,0xF81F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}

//#define PuzzleTile4	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xF00F,0xE007,0xC003,0xE007,0xF81F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}
#define PuzzleTile4	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xF00F,0xE007,0xC003,0xE007,0xF81F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}

//#define PuzzleTile5	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}
#define PuzzleTile5	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFC3F,0xF81F,0xFC3F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}

//#define PuzzleTile6	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}
#define PuzzleTile6	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}

#define NextLevTile1	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFC,0xFFE3,0xFF9F,0xFE7F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFC,0xFFE0,0xFF80}

#define NextLevTile2	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xC007,0x7FF8,0xFFFF,0xFE00,0xF1FF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x8007,0x0000,0x01FF,0x0FFF}

#define NextLevTile3	{0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x3FFF,0xDFFF,0x2FFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x3FFF,0xDFFF}

#define NextLevTile4	{0xF9FF,0xF3FF,0xE7FE,0xCFFC,0xDFF9,0xBFFB,0xBFF3,0x7FF7,0x7FF7,0x7FF7,0x7FF3,0x7FFB,0x3FF9,0xBFFC,0x9FFE,0xDFFF,0xFE00,0xFC00,0xF801,0xF003,0xE007,0xC007,0xC00F,0x800F,0x800F,0x800F,0x800F,0x8007,0xC007,0xC003,0xE001,0xE000}

#define NextLevTile5	{0xCF7E,0x3BC3,0x7E00,0xD800,0xB000,0xE000,0x4000,0xC000,0xC000,0x4000,0xE000,0xB000,0xD800,0xEE00,0x7BC3,0x3F7E,0x3F81,0xFC3C,0xF181,0xE600,0xC800,0x9000,0xA000,0x2000,0x2000,0xA000,0x9000,0xC800,0xE600,0xF181,0xFC3C,0xFF81}

#define NextLevTile6	{0xC7FF,0xDBFF,0x6FFF,0x1FFF,0x0DFF,0x07FF,0x02FF,0x03FF,0x03FF,0x02BF,0x07BF,0x0D5F,0x1F5F,0x6EDF,0xDCDF,0xF9BF,0xFFFF,0x3FFF,0x9FFF,0x67FF,0x13FF,0x09FF,0x05FF,0x04FF,0x04FF,0x05FF,0x09FF,0x13BF,0x67BF,0x9F3F,0x3F3F,0xFE7F}

#define NextLevTile7	{0xEFFF,0xE7FF,0xF3FF,0xF9FF,0xFC7F,0xFF0F,0xFFE0,0xFFFE,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF000,0xF800,0xFC00,0xFE00,0xFF80,0xFFF0,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}

#define NextLevTile8	{0xCFFF,0xF07F,0xFE00,0xFFFF,0xFFFF,0xFFFF,0xFFE0,0x0007,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x3FFF,0x0FFF,0x01FF,0x0000,0x0000,0x0000,0x001F,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}

#define NextLevTile9	{0xE7BF,0x1F7F,0xFCFF,0xF9FF,0xE7FF,0x1FFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF87F,0xE0FF,0x03FF,0x07FF,0x1FFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF}



unsigned short Tiles[][32] = {
	BlackTile,
	
	PuzzleTile1,
	PuzzleTile2,
	
	NextLevTile1,
	NextLevTile2,
	NextLevTile3,
	NextLevTile4,
	NextLevTile5,
	NextLevTile6,
	NextLevTile7,
	NextLevTile8,
	NextLevTile9,
	
	Item1Spr,
	Item2Spr,
	Item3Spr,
	Item4Spr,
	Item5Spr,
	Item6Spr,
	Item7Spr,
	Item8Spr,
	Item9Spr,
	Item10Spr,
		
	ArrowTile2,
	Arrow2Tile2,
	ArrowTile4,
	Arrow2Tile4,
	ArrowTile3,
	Arrow2Tile3,
	ArrowTile1,	
	Arrow2Tile1,
	
	WallTile1,
	WallTile2,
	

	
};


#endif



char GetTile(short X,short Y);

void PutTile(short X,short Y,char Tile);




#endif