
#include "all.h"

void ClearScreenBuffer(){
	memset(GrayDBufGetHiddenPlane(LIGHT_PLANE),0,LCD_SIZE);
	memset(GrayDBufGetHiddenPlane(DARK_PLANE),0,LCD_SIZE);
};

void DrawString(short x,short y,const char* s,short attr){
	GrayDrawStrExt2B( x, y, s, attr,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
};

void ContrastAdjust(){
	/*******************************************************************************************
	This function adjusts the contrast settings by pressing the +/- keys.
		
	********************************************************************************************/
	
	if(KeyState.Plus){
		OSContrastUp();
	}
	else{
		if(KeyState.Minus){
			OSContrastDn();
		};
	};
	
};

void Render(short ShowStats){
	
	// Erase the content of the buffer	
	/*memset(GrayDBufGetHiddenPlane(LIGHT_PLANE),0,LCD_SIZE);
	memset(GrayDBufGetHiddenPlane(DARK_PLANE),0,LCD_SIZE);*/
	ClearScreenBuffer();
	
	// Draw 8x8 tilemap
	DrawTiles();
	
	// Draw player (Sphere)
	GrayClipSprite16_SMASK_R(Player.X,Player.Y,TileDim,SphereSprite,SphereSprite+TileDim,SphereSprite+TileDim*2,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
	
	char String[14];
		
	if(ShowStats){
		// Draw Hud	
		//sprintf(String, "Step: %d",Player.Step);
		sprintf(String,SStep,Player.Step);
		//DrawGrayStrExt2B(8*TileDim+2,ScreenHeight-18,"Step: ",A_REPLACE,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
		DrawGrayStrExt2B(8*TileDim+2,ScreenHeight-18,String,A_REPLACE,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
	
		//sprintf(String, "Rotate: %d",Player.Rotate);
		sprintf(String,SRotate,Player.Rotate);
		DrawGrayStrExt2B(8*TileDim+2,ScreenHeight-28,String,A_REPLACE,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));

	}
	else{
		short C;
		for(C=0;C<10000;C++);
	};

	short C;
	short X = TileDim*8+4,Y = 0;
	for(C=0;C<NrOfItemTiles;C++){
		
		if(Gamedata.NrOfItems[C]){
			
			unsigned short* Sprite = Tiles[TileItemLow+C];
			
			GrayClipSprite16_RPLC_R(X,Y,TileDim,Sprite,Sprite+TileDim,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
			
			sprintf(String, "%d",Gamedata.NrOfItems[C]);
			DrawGrayStrExt2B(X+TileDim+2,Y+2,String,A_REPLACE,F_6x8,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));

			Y += TileDim;
			if(Y >= (TileDim*5) ){
				X = TileDim*8+4 + TileDim*2+4;
				Y = 0;
			};
		};		
	};	
	
	// Toggle double buffered planes
	GrayDBufToggleSync();
	
};
/*
void DrawTiles(){
	short Row,Col;
	
	short AddTx,AddTy;
	
	for(Row=0;Row<8;Row++){
		short XOff;
		
		if(Gamedata.SlideRow == Row){
			XOff = (TileDim-Gamedata.Sliding)*Gamedata.SlideDir;
		}
		else{
			XOff = 0;
		};			
		
		for(Col=0;Col<8;Col++){
			char Tile = GetTile(Col,Row);
			
			unsigned short* Sprite = Tiles[(short)Tile];// + Tile*32;
			short YOff;			
			
			if(Gamedata.SlideCol == Col){				
				YOff = (TileDim-Gamedata.Sliding)*Gamedata.SlideDir;
			}
			else{
				YOff = 0;
			};			
			
			if( (Gamedata.Flashing%2) && ((*(Gamedata.Puzzle+64+8*Row+Col))==1) ){
				Sprite = Tiles[0];
			};
			
			DrawTileWrap(Col*TileDim+XOff,Row*TileDim+YOff,Sprite);
		};
		
	};	
	
	
};
*/

void DrawTiles(){
	short Row,Col;
	
	short AddTx,AddTy;
	
	for(Col=0;Col<8;Col++){	
		short YOff;
		
		if(Gamedata.SlideCol == Col){				
			YOff = (TileDim-Gamedata.Sliding)*Gamedata.SlideDir;
		}
		else{
			YOff = 0;
		};	

		for(Row=0;Row<8;Row++){		

			char Tile = GetTile(Col,Row);
			
			unsigned short* Sprite = Tiles[(short)Tile];// + Tile*32;						
			
			short XOff;
		
			if(Gamedata.SlideRow == Row){
				XOff = (TileDim-Gamedata.Sliding)*Gamedata.SlideDir;
			}
			else{
				XOff = 0;
			};
			
			if( (Gamedata.Flashing%2) && ((*(Gamedata.Puzzle+64+8*Row+Col))==1) ){
				Sprite = Tiles[0];
			};
			
			DrawTileWrap(Col*TileDim+XOff,Row*TileDim+YOff,Sprite);
		};
		
	};		
	
};


void DrawTileWrap(short X,short Y,unsigned short* Sprite){
	
	short AdX=0,AdY=0;
	
	if( (X<0) ){
		AdX = TileDim*8+X;
		AdY = Y;
	};
	if( (X>(7*TileDim)) ){
		AdX = X-TileDim*8;
		AdY = Y;
	};
	if( (Y<0) ){
		AdX = X;
		AdY = TileDim*8+Y;
	};
	if( (Y>(7*TileDim)) ){
		AdX = X;
		AdY = Y-TileDim*8;
	};	
	
	GrayClipSprite16_OR_R(X,Y,TileDim,Sprite,Sprite+TileDim,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
	
	if(AdX || AdY){
		GrayClipSprite16_OR_R(AdX,AdY,TileDim,Sprite,Sprite+TileDim,GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE));
	};
	if( (X<0) || (X>7*TileDim) ){
		GrayFastFillRect_R(GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE), (8*TileDim),Y,(9*TileDim),min(Y+TileDim,127),COLOR_WHITE);
	};
	
	#ifdef PRODUCE_TI89_CODE
	if(Y>7*TileDim){
		GrayFastFillRect_R(GrayDBufGetHiddenPlane(LIGHT_PLANE),GrayDBufGetHiddenPlane(DARK_PLANE),X,8*TileDim,X+TileDim,9*TileDim,COLOR_WHITE);
	};
	#endif
	
};


void DrawFrame(short X1,short Y1,short X2,short Y2){
	
	GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE), X1,Y1,X2,Y2,COLOR_WHITE);

	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE), X1,Y1,X2,Y2,COLOR_DARKGRAY);
	GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE), X1+1,Y1+1,X2-1,Y2-1,COLOR_LIGHTGRAY);
	
};



