
#include "all.h"


player Player;


void HandlePlayer(){
	
	if( (Gamedata.Sliding==0) && (Gamedata.Flashing==0) ){
	
	if( (Player.XMotion || Player.YMotion) ){
		
		if(Player.XMotion){
			if(Player.XMotion>0){
				Player.XMotion -= PlayerMotionSpeed;
				Player.X += PlayerMotionSpeed;
			}
			else{
				Player.XMotion += PlayerMotionSpeed;
				Player.X -= PlayerMotionSpeed;
			};
		};
		
		if(Player.YMotion){
			if(Player.YMotion>0){
				Player.YMotion -= PlayerMotionSpeed;
				Player.Y += PlayerMotionSpeed;
			}
			else{
				Player.YMotion += PlayerMotionSpeed;
				Player.Y -= PlayerMotionSpeed;
			};
		};
		
		if( (Player.XMotion==0) && (Player.YMotion==0) ){
			// Check for collision with arrows
			char Tile = GetTile(Player.X/TileDim,Player.Y/TileDim);
		
			if( (Gamedata.Sliding==0) && (Tile>=TileArrowLow) && (Tile<=TileArrowHigh) ){
				// Player has hit an arrow
			
				Gamedata.Sliding = TileDim;
			
				if( (Tile>=TileArrDnLow) && (Tile<=TileArrDnHigh) ){
					Gamedata.SlideCol = Player.X/TileDim;
					Gamedata.SlideDir = 1;	
					Player.Rotate++;		
				}
				else{
					if( (Tile>=TileArrUpLow) && (Tile<=TileArrUpHigh) ){
						Gamedata.SlideCol = Player.X/TileDim;
						Gamedata.SlideDir = -1;	
						Player.Rotate++;			
					}
					else{
						if( (Tile>=TileArrLeLow) && (Tile<=TileArrLeHigh) ){
							Gamedata.SlideRow = Player.Y/TileDim;
							Gamedata.SlideDir = -1;		
							Player.Rotate++;	
						}
						else{
							if( (Tile>=TileArrRiLow) && (Tile<=TileArrRiHigh) ){
								Gamedata.SlideRow = Player.Y/TileDim;
								Gamedata.SlideDir = 1;	
								Player.Rotate++;			
							};
						};
					};
				};			
			};
		};
		
	}
	else{
		
			if(KeyState.Up){
				if( (Player.Y>0) && ((GetTile(Player.X/TileDim,Player.Y/TileDim-1)<TileSolidLow) || Player.Hovering) ){
					// Player is free to move
					Player.YMotion = -TileDim;
					Player.Step++;	
				};
			}
			else{
				if(KeyState.Down){
					if( (Player.Y<7*TileDim) && ((GetTile(Player.X/TileDim,Player.Y/TileDim+1)<TileSolidLow) || Player.Hovering) ){
					// Player is free to move
						Player.YMotion = TileDim;
						Player.Step++;	
					};
				}
				else{
					if(KeyState.Left){
						if( (Player.X>0) && ((GetTile(Player.X/TileDim-1,Player.Y/TileDim)<TileSolidLow) || Player.Hovering) ){
						// Player is free to move
							Player.XMotion = -TileDim;
							Player.Step++;	
						};
					}
					else{
						if(KeyState.Right){
							if( (Player.X<7*TileDim) && ((GetTile(Player.X/TileDim+1,Player.Y/TileDim)<TileSolidLow) || Player.Hovering) ){
								// Player is free to move
								Player.XMotion = TileDim;
								Player.Step++;									
							};
						};
					};
				};		
			};
			
			if(Player.XMotion || Player.YMotion){
				// A step has been initiated...
				// Move Player.Step++; here to save some bytes
				if(Player.Hovering){
					Player.Hovering--;
				};
			};			
		};	
	};
	
	if(KeyState.Second){
		// Teacher key: Turn the calc off
		off();
	};
	
};

void AdditionalPlayerControls(){
		
	if(KeyState.Enter){
		
		short Selected = 0;
		short Cursor = 0;
		while(!Selected){
				
			GrayFastFillRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE), 0,36,16*8+4,60,COLOR_WHITE);
				
			short C;
			for(C=0;C<8;C++){
				
				if(Player.Items[C]>=0){						
					
					unsigned short* Sprite = MagicSprites+16*2*Player.Items[C];					
				
					GrayClipSprite16_RPLC_R(C*16+2,40,16,Sprite,Sprite+16,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
				};							
					
			};
				
			GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE), Cursor*16,39-2,Cursor*16+16+2,39+16+2,COLOR_BLACK);
			GrayFastOutlineRect_R(GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE), Cursor*16+1,39-1,Cursor*16+16+1,39+16+1,COLOR_BLACK);
				
			WaitKeyPress();
			KeyScan();
				
			if(KeyState.Enter){
				Selected = 1;
				// Apply item
				switch(Player.Items[Cursor]){
					case 0:
						UseLightningBolt();
					break;
					case 1:
						Player.Hovering = 5;
					break;
					case 2:
						UseFlash();
					break;						
				};	
				
				for(C=Cursor;C<7;C++){// Move all elements one step to the left
					Player.Items[C] = Player.Items[C+1];
				};				
				Player.Items[7] = -1;	
				Gamedata.MagicUsed = 1;				
				
			};				
			if(KeyState.Esc){
				Selected = 1;
				KeyState.Esc = 0;
			};
			if(KeyState.Left){
				if(Cursor>0){
					Cursor--;
				};
			};
			if(KeyState.Right){
				if( (Cursor<7) && (Player.Items[Cursor+1]>=0) ){
					Cursor++;
				};
			};
			
				
		};			
		WaitKeyReleased();//while(_rowread(0));//wait until key released
	};
	
	if(KeyState.Esc){
		//short Res = YesNoPrompt("Give up?");	
		short Res = YesNoPrompt(SGiveUp);	
		
		
		if(Res){
			Gamedata.Exit = PuzzleFailed;
		};
		
	};		
	
};

void UseLightningBolt(){
	
	memset(Gamedata.Puzzle+64,0,64);
	
	short Row,Col;
	for(Row=-1;Row<=1;Row++){
		for(Col=-1;Col<=1;Col++){
			char Tile = GetTile(Player.X/TileDim+Col,Player.Y/TileDim+Row);
			if( (Tile>=TileWallLow) && (Tile<=TileWallHigh) ){
				*(Gamedata.Puzzle+64+8*(Player.Y/TileDim+Row)+(Player.X/TileDim+Col)) = 1;
			};
		};
	};	
	
	Gamedata.Flashing = FlashTime;
	
};

void UseFlash(){
	
	memset(Gamedata.Puzzle+64,0,64);
	
	short Row,Col;
	for(Row=0;Row<=7;Row++){
		for(Col=0;Col<=7;Col++){
			char Tile = GetTile(Col,Row);
			if( (Tile>=TileWallLow) && (Tile<=TileWallHigh) ){
				*(Gamedata.Puzzle+64+8*Row+Col) = 1;
			};
		};
	};
	
	Gamedata.Flashing = FlashTime;
	
};