
#include "all.h"




void PlayPuzzle(){		
	
	
	Gamedata.Exit = 0;
	Gamedata.Sliding = 0;
	Gamedata.SlideCol = -1;
	Gamedata.SlideRow = -1;
	
	Player.Step = 0;
	Player.Rotate = 0;
	
	WaitKeyReleased();//while(_rowread(0));//wait until key released
		
	while(Gamedata.Exit==0){
		
		Render(1);		

		WaitForEvent();
		
		KeyScan();
		
		ContrastAdjust();
		
		AdditionalPlayerControls();
		
		HandlePlayer();				
		
		HandlePuzzle();
		
	};	
	
	Player.XMotion = Player.YMotion = 0;
	Gamedata.Sliding = 0;
	Gamedata.SlideCol = -1;
	Gamedata.SlideRow = -1;
	Gamedata.Flashing = 0;
	
};

void WaitForEvent(){
	
	if( !Gamedata.Flashing && !Player.XMotion && !Player.YMotion && !Gamedata.Sliding /*!Gamedata.SlideRow && !Gamedata.SlideCol*/ ){
				
		while(!_rowread(0));//wait until key pressed
		
	}
	else{
		if(Gamedata.Flashing){
			short Wait;
			for(Wait=0;Wait<30000;Wait++);
		};
	};
	
};

void HandlePuzzle(){

	if(Gamedata.Sliding){			
		if( (Gamedata.Sliding-=SlideSpeed)<=0 ){
			if(Gamedata.SlideCol>=0){
				
				short Y = (Gamedata.SlideDir<0?1:6);
				char FirstTile = GetTile(Gamedata.SlideCol,Y+Gamedata.SlideDir);
				
				while( (Y>=0) && (Y<=7) ){
					PutTile( Gamedata.SlideCol, Y+Gamedata.SlideDir, GetTile(Gamedata.SlideCol, Y) );
					Y -= Gamedata.SlideDir;
				};
				
				PutTile( Gamedata.SlideCol, Y+Gamedata.SlideDir, FirstTile);
	
			}
			else{
				// SlideRow
					
				short X = (Gamedata.SlideDir<0?1:6);
				char FirstTile = GetTile(X+Gamedata.SlideDir,Gamedata.SlideRow);
				
				while( (X>=0) && (X<=7) ){
					PutTile( X+Gamedata.SlideDir, Gamedata.SlideRow, GetTile(X, Gamedata.SlideRow) );
					X -= Gamedata.SlideDir;
				};
				
				PutTile( X+Gamedata.SlideDir, Gamedata.SlideRow, FirstTile);
				
			};			
			Gamedata.SlideCol = -1;
			Gamedata.SlideRow = -1;
		
			// Check for matches
			memset(Gamedata.Puzzle+64,0,64);
			
			short Col,Row;
			
			for(Col=0;Col<=7;Col++){
				for(Row=0;Row<=7;Row++){
					char Tile = GetTile(Col,Row);
					if( (Tile>=TileItemLow) && (Tile<=TileItemHigh) ){
						// Current tile is an item tile. Check for matches
						short Dx,Dy;
						for(Dx=-1;Dx<=1;Dx+=2){
							if( Tile==GetTile(Col+Dx,Row) ){
								// Match found
								*(Gamedata.Puzzle+64+8*Row+Col+Dx) = 1;
								Gamedata.Flashing = FlashTime;
							};
						};
						for(Dy=-1;Dy<=1;Dy+=2){
							if( Tile==GetTile(Col,Row+Dy) ){
								// Match found
								*(Gamedata.Puzzle+64+8*(Row+Dy)+Col) = 1;
								Gamedata.Flashing = FlashTime;
							};
						};
					};
				};
			};		
		};
	}
	else{
		// Not sliding
		short Col,Row,Completed = 1;
		
		if(Gamedata.Flashing){
			if( (--Gamedata.Flashing)<=0 ){
				for(Col=0;Col<=7;Col++){
					for(Row=0;Row<=7;Row++){
						if( *(Gamedata.Puzzle+64+8*Row+Col) ){
							
							char Tile = GetTile(Col,Row);
							if( (Tile>=TileItemLow) && (Tile<=TileItemHigh) ){
								Gamedata.NrOfItems[Tile-TileItemLow]--;
							};
														
							PutTile(Col,Row,0);
						}
						else{
							if( (GetTile(Col,Row)>=TileItemLow) && (GetTile(Col,Row)<=TileItemHigh)){
								Completed = 0;
							};
						};
					};
				};
				// Check if Puzzle is completed
				if(Completed){
					Gamedata.Exit = PuzzleCleared;
					DrawFrame(1,17,126,32);
					//DrawGrayStrExt2B(4,20,"Puzzle cleared!",A_REPLACE|A_SHADOWED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
					//DrawString(4,20,"Puzzle cleared!",A_REPLACE|A_SHADOWED);
					DrawString(4,20,SPuzzleCleared,A_REPLACE|A_SHADOWED);					
					long Delay;
					for(Delay=0;Delay<800000;Delay++);					
				};
				
				// Check if puzzle is impossible to complete
				short C;
				for(C=0;C<NrOfItemTiles;C++){
					if(Gamedata.NrOfItems[C]==1){
						Gamedata.Exit = PuzzleFailed;	
						DrawFrame(1,17,119,32);
						//DrawGrayStrExt2B(4,20,"Puzzle failed!",A_REPLACE|A_SHADOWED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						//DrawString(4,20,"Puzzle failed!",A_REPLACE|A_SHADOWED);
						DrawString(4,20,SPuzzleFailed,A_REPLACE|A_SHADOWED);
						long Delay;
						for(Delay=0;Delay<800000;Delay++);				
					};
				};				
			};
		};		
	};
	
}
