// C Source File
// Created 30.06.2008; 21:21:35


#include "all.h"

// Main Function
void _main(void)
{
	
	// Redirecting auto-int 1 and 5
	INT_HANDLER ai1,ai5;
	ai1 = GetIntVec(AUTO_INT_1);
	ai5 = GetIntVec(AUTO_INT_5);
	SetIntVec(AUTO_INT_1,DUMMY_HANDLER);
	SetIntVec(AUTO_INT_5,DUMMY_HANDLER);

	
	// Turn on GrayScale
	if(!GrayOn())	
	{// Failed to turn on GrayScale
		Gamedata.ErrorCode = GrayError;
		goto Quit;
	};
	
	// Allocate ram for GFX / Grayscale
	void* Block = NULL;
	
	Block = malloc( ((unsigned long)GRAYDBUFFER_SIZE + 64*3 ) );
	
	if(Block==NULL){
		Gamedata.ErrorCode = MemError;
		goto Quit;
	};
		
	//Initialize TIGCC double buffering
	GrayDBufInit (Block);
	
	Gamedata.Puzzle = Block + GRAYDBUFFER_SIZE+2;
	
	randomize();
		
	Menus();
	
	
	Quit:
	
	// Turn off GrayScale
	GrayOff();	
	
	if(Gamedata.ErrorCode){
		DispErrorMsg(Gamedata.ErrorCode);
	};

	// Free allocated memory
	if(Block)
		free(Block);	
	
	// Wait until key released
	WaitKeyReleased();//while(_rowread(0));
	
	// Reinstall auto-int 1 and 5
	SetIntVec(AUTO_INT_5,ai5);
	SetIntVec(AUTO_INT_1,ai1);
		
	// Clear all keypresses.
	GKeyFlush();
};
