
#include "all.h"


void SaveProgress(){
	
	savedata SaveData;
	
	memcpy(SaveData.CompletedPuzzle,Gamedata.CompletedPuzzle,6*sizeof(short));	
	memcpy(SaveData.Items,Player.Items,8*sizeof(char));
	
	SaveData.PlayerX = Player.X;
	SaveData.PlayerY = Player.Y;
	SaveData.MagicUsed = Gamedata.MagicUsed;
	SaveData.Level = Gamedata.Level;
	SaveData.DifficultyCondition = Gamedata.DifficultyCondition;
	SaveData.CompletedCounter = Gamedata.CompletedCounter;
	
	FILES fsPtr;
	
	if( !EM_moveSymFromExtMem ( SYMSTR(SaveFileName), HS_NULL ) ){
		//goto failure;
	};
	
	if(FOpen (SaveFileName, &fsPtr, FM_WRITE, "ESAV")!=FS_OK){
		goto failure;
	};
	
	if(FWrite (&SaveData, sizeof(SaveData), &fsPtr)!=FS_OK){
		goto failure;
	};
	
	FClose (&fsPtr); 

	if(ArchiveFile()){
		goto failure;
	};
	
	return ;
	
	failure:
	
	#ifndef PRODUCE_TI89_CODE
	DrawFrame(50,72,194,102);
	//DrawGrayStrExt2B(10,76,"Could not save",A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	//DrawString(10,76,"Could not save",A_REPLACE|A_SHADOWED|A_CENTERED);
	DrawString(10,76,SErrSave,A_REPLACE|A_SHADOWED|A_CENTERED);
	#endif
	
	#ifdef PRODUCE_TI89_CODE
	DrawFrame(20,55,140,73);
	//DrawGrayStrExt2B(10,59,"Could not save",A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	//DrawString(10,59,"Could not save",A_REPLACE|A_SHADOWED|A_CENTERED);
	DrawString(10,59,SErrSave,A_REPLACE|A_SHADOWED|A_CENTERED);
	#endif
		
	
	WaitKeyPress();		
	
	
};

short LoadProgress(){
	savedata SaveData;
	FILES fsPtr;
	
	if(FOpen (SaveFileName, &fsPtr, FM_READ, "ESAV")!=FS_OK){
		goto failure;
	};
	
	if(FRead (&SaveData, sizeof(SaveData), &fsPtr)!=FS_OK){
		goto failure;
	};
	
	FClose (&fsPtr); 
	
	memcpy(Gamedata.CompletedPuzzle,SaveData.CompletedPuzzle,6*sizeof(short));	
	memcpy(Player.Items,SaveData.Items,8*sizeof(char));
	
	Player.X = SaveData.PlayerX;
	Player.Y = SaveData.PlayerY;
	Gamedata.MagicUsed = SaveData.MagicUsed;
	Gamedata.Level = SaveData.Level;
	Gamedata.DifficultyCondition = SaveData.DifficultyCondition;
	Gamedata.CompletedCounter = SaveData.CompletedCounter;
	

	return 0;
	
	failure:
	
	return LoadingFailed;
};

short ArchiveFile(){
	
	short Tries = 0;
	
	while(Tries<2){//0 or 1 try
		
		if( EM_findEmptySlot(100) ){//large enough empty slot in archive mem?
			//save:
						
			// Archive
			if( !EM_moveSymToExtMem ( SYMSTR(SaveFileName), HS_NULL ) ){
				goto failure;
			}
			break;// Break out of while loop
		}
		else{//No free flash mem blocks that are large enough 
			//Garbage collect, display no dialog
			
			if(Tries>0)// Tried garbage collection already, no point in trying twice
				goto failure;
			
			if(EM_GC (FALSE)){
				
			};
			Tries++;	
				
		};		
	};
	
	return 0;
	
	failure:
	
	return 1;
	
}