

#include "all.h"


keystate KeyState;

void WaitKeyPress(){
	/*******************************************************************************************
	This function waits until any key is pressed.
		
	********************************************************************************************/
	
	WaitKeyReleased();//while(_rowread(0));//wait until key released
	while(!_rowread(0));//wait until key pressed
};

void WaitKeyReleased(){
	while(_rowread(0));//wait until key released
};

#ifdef PRODUCE_TI92PLUS_CODE

void KeyScan(){
	/*******************************************************************************************
	This function detects all valid keypresses.
	The result is saved in the KeyState struct.
	The result from previous call to this function will at any time be saved in PrevKeyState.
	All non-zero values indicates that a key is pressed.
	
	********************************************************************************************/

	unsigned short Row;
		
	Row = _rowread(0b1111111110);
	KeyState.Up    = Row & 0b00100000;
	KeyState.Left  = Row & 0b00010000;
	KeyState.Right = Row & 0b01000000;
	KeyState.Down  = Row & 0b10000000;	
	KeyState.Second = Row & 0b00000001;
	
	Row = _rowread(0b1011111111);
	KeyState.Esc   = Row & 0b01000000;
	KeyState.Plus  = Row & 0b00010000;
	
	Row = _rowread(0b1110111111);
	KeyState.Enter = Row & 0b01000000;//Enter2
	Row = _rowread(0b0111111111);
	KeyState.Enter = KeyState.Enter|(Row & 0b00000010);
	KeyState.Minus = Row & 0b00000001;
	
	
	
};

#endif


#ifdef PRODUCE_V200_CODE

void KeyScan(){
	/*******************************************************************************************
	This function detects all valid keypresses.
	The result is saved in the KeyState struct.
	The result from previous call to this function will at any time be saved in PrevKeyState.
	All non-zero values indicates that a key is pressed.
	
	********************************************************************************************/

	unsigned short Row;
		
	Row = _rowread(0b1111111110);
	KeyState.Up    = Row & 0b00100000;
	KeyState.Left  = Row & 0b00010000;
	KeyState.Right = Row & 0b01000000;
	KeyState.Down  = Row & 0b10000000;	
	
	Row = _rowread(0b1011111111);
	KeyState.Esc   = Row & 0b01000000;
	KeyState.Plus  = Row & 0b00010000;
	
	Row = _rowread(0b1110111111);
	KeyState.Enter = Row & 0b01000000;//Enter2
	Row = _rowread(0b0111111111);
	KeyState.Enter = KeyState.Enter|(Row & 0b00000010);
	KeyState.Minus = Row & 0b00000001;
	
};

#endif


#ifdef PRODUCE_TI89_CODE

void KeyScan(){
	/*******************************************************************************************
	This function detects all valid keypresses.
	The result is saved in the KeyState struct.
	The result from previous call to this function will at any time be saved in PrevKeyState.
	All non-zero values indicates that a key is pressed.
	
	********************************************************************************************/

	unsigned short Row;
		
	Row = _rowread(0b1111111110);
	KeyState.Up    = Row & 0b00000001;
	KeyState.Left  = Row & 0b00000010;
	KeyState.Right = Row & 0b00001000;
	KeyState.Down  = Row & 0b00000100;	
	KeyState.Second = Row & 0b00010000;
	
	Row = _rowread(0b1110111111);
	KeyState.Esc   = Row & 0b00000001;
	
	Row = _rowread(0b1111111101);
	KeyState.Enter = Row & 0b00000001;
	KeyState.Plus  = Row & 0b00000010;
	KeyState.Minus = Row & 0b00000100;
	
};

#endif


short YesNoPrompt(const char* Question){
	
	DrawFrame(25,25,118,69);
	
	//DrawGrayStrExt2B(30,30,Question,A_REPLACE|A_SHADOWED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	DrawString(30,30,Question,A_REPLACE|A_SHADOWED);
	//DrawGrayStrExt2B(30,42,"Enter=Yes",A_REPLACE|A_SHADOWED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	//DrawString(30,42,"Enter=Yes",A_REPLACE|A_SHADOWED);
	DrawString(30,42,SEnterYes,A_REPLACE|A_SHADOWED);
	
	//DrawGrayStrExt2B(30,54,"Esc=No",A_REPLACE|A_SHADOWED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
	//DrawString(30,54,"Esc=No",A_REPLACE|A_SHADOWED);
	DrawString(30,54,SEscNo,A_REPLACE|A_SHADOWED);
	
	WaitKeyPress();
			
	KeyScan();
	WaitKeyReleased();//while(_rowread(0));//wait until key released
	
	if(KeyState.Enter){
		return 1;
	}
	else{
		return 0;
	};	
	
};