
#include "all.h"

void LoadSelectScreen(short Attr){
	
	short Offset = 0;
	if(Attr>1){
		Offset = 64;
	};
	memcpy(Gamedata.Puzzle,SelScreen+Offset,64);
	
	
	if(Attr==0){
		Player.X = 4*TileDim;
		Player.Y = 3*TileDim;
	}
	else{
		short C;
		for(C=0;C<6;C++){
			if(Gamedata.CompletedPuzzle[C]){
				short XP[6]={4,6,6,4,2,2};
				short YP[6]={1,2,4,5,4,2};
				PutTile(XP[C],YP[C],p2);
			};
		};
	};
		
};

void NewGameInit(){
	LoadSelectScreen(0);
	
	memset(Gamedata.CompletedPuzzle,0,6*sizeof(short));
	Gamedata.CompletedCounter = 0;
	Gamedata.Level = 0;
	Gamedata.MagicUsed = 0;
	
	const char ItemInit[8] = {0,1,2,-1,-1,-1,-1,-1};
	memcpy(Player.Items,ItemInit,8);
	
	// Test stuff
	//Gamedata.Level = 4;
	
	
};

void GameLoop(){
	
	WaitKeyReleased();//while(_rowread(0));//wait until key released
		
	while(Gamedata.Exit==0){
		
		// Draw the puzzle selection screen
		Render(0);
		
		WaitForEvent();
		
		KeyScan();		
		
		ContrastAdjust();
		
		if(KeyState.Esc){
			//short Res = YesNoPrompt("Quit?");	
			short Res = YesNoPrompt(SQuitPrompt);				
			
			if(Res){
				Gamedata.Exit = PuzzleFailed;
				KeyState.Enter = 0;
			};
		};
		
		// Handle player navigation
		HandlePlayer();
		
		// Select puzzle
		if(KeyState.Enter){
			
			char Tile = GetTile(Player.X/TileDim,Player.Y/TileDim);
			if( (Tile>=TilePuzzleLow) && (Tile<=TilePuzzleHigh) ){
				short Puzzle = -1;
				switch(Player.Y){
					case (1*TileDim):
						Puzzle = 0;
					break;
					case (2*TileDim):
						if(Player.X<=(2*TileDim)){
							Puzzle = 5;
						}
						else{
							Puzzle = 1;
						};
					break;
					case (4*TileDim):
						if(Player.X<=(2*TileDim)){
							Puzzle = 4;
						}
						else{
							Puzzle = 2;
						};
					break;
					case (5*TileDim):
						Puzzle = 3;
					break;
				};
			
				if(Puzzle>=0){
					
					short SavedX = Player.X;
					short SavedY = Player.Y;
					
					LoadPuzzle(Puzzle+Gamedata.Level*6);
	
					PlayPuzzle();					
					
					if(Gamedata.Exit==PuzzleCleared){
						PutTile(Player.X/TileDim,Player.Y/TileDim,p2);
						if(Gamedata.CompletedPuzzle[Puzzle]==0){
							Gamedata.CompletedPuzzle[Puzzle] = 1;
							Gamedata.CompletedCounter++;
						};
					};					
					
					Gamedata.Exit = 0;
					
					Player.X = SavedX;
					Player.Y = SavedY;
					
					SaveProgress();
					
					memset(Gamedata.NrOfItems,0,sizeof(short)*NrOfItemTiles);
					
					LoadSelectScreen((Gamedata.CompletedCounter>=Gamedata.DifficultyCondition?2:1));
					WaitKeyReleased();//while(_rowread(0));//wait until key released
					
				};			
			
			}
			else{
				if( (Tile>=TileProceedLow) && (Tile<=TileProceedHigh) ){
					// Proceed to next level
										
					if( (++Gamedata.Level) < NrOfLevels){
						DrawFrame(1,17,120,32);
						//DrawGrayStrExt2B(4,20,"Level cleared!",A_REPLACE|A_SHADOWED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						//DrawString(4,20,"Level cleared!",A_REPLACE|A_SHADOWED);
						DrawString(4,20,SLevelCleared,A_REPLACE|A_SHADOWED);
					
						//WaitKeyPress();						
						long Delay;
						for(Delay=0;Delay<800000;Delay++);
						
						if(!Gamedata.MagicUsed){
							// Receive a magic item
							short C;
							for(C=0;C<8;C++){
								if(Player.Items[C] == -1){
									Player.Items[C] = random(3);
									break;
								};
							};
						};
						
						// Transition animation
						DisplayTitleScreen(DARK_PLANE,DARK_PLANE);//LIGHT_PLANE,LIGHT_PLANE);
						GrayDBufToggleSync();
						char String [10];
						//sprintf(String, "Level %d",Gamedata.Level+1);
						sprintf(String, SLevel,Gamedata.Level+1);
											
						#ifndef PRODUCE_TI89_CODE
						DrawFrame(70,75,170,90);
						//DrawGrayStrExt2B(10,78,String,A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						DrawString(10,78,String,A_REPLACE|A_SHADOWED|A_CENTERED);
						#endif
						
						#ifdef PRODUCE_TI89_CODE						
						DrawFrame(40,62,118,80);
						//DrawGrayStrExt2B(10,66,String,A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						DrawString(10,66,String,A_REPLACE|A_SHADOWED|A_CENTERED);
						#endif
						
						WaitKeyPress();
						
						Gamedata.CompletedCounter = 0;
						memset(Gamedata.CompletedPuzzle,0,6*sizeof(short));
						LoadSelectScreen(0);
						SaveProgress();
					}
					else{
						// Game completed!
						DisplayTitleScreen(DARK_PLANE,LIGHT_PLANE);	
						GrayDBufToggleSync();
						
						#ifndef PRODUCE_TI89_CODE			
						
						#ifdef german
						DrawFrame(25,72,214,102);// Ok
						#endif
						#ifdef french
						DrawFrame(42,72,198,102);// Ok
						#endif
						#ifdef english
						DrawFrame(50,72,194,102);// Ok
						#endif
						//DrawGrayStrExt2B(10,76,"Game Completed!",A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						//DrawString(10,76,"Game Completed!",A_REPLACE|A_SHADOWED|A_CENTERED);
						DrawString(10,76,SGameCompleted,A_REPLACE|A_SHADOWED|A_CENTERED);
						
						//DrawGrayStrExt2B(10,88,"Congratulations!",A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						//DrawString(10,88,"Congratulations!",A_REPLACE|A_SHADOWED|A_CENTERED);
						DrawString(10,88,SCongrat,A_REPLACE|A_SHADOWED|A_CENTERED);
						#endif
						
						#ifdef PRODUCE_TI89_CODE	
						
						#ifdef german
						DrawFrame(6,62,154,92);// 
						#endif
						#ifdef french
						DrawFrame(2,62,158,92);// Ok
						#endif
						#ifdef english
						DrawFrame(12,62,148,92);// Ok
						#endif
											
						//DrawFrame(12,62,148,92);
						#ifndef german
						//DrawGrayStrExt2B(10,66,"Game Completed!",A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						//DrawString(10,66,"Game Completed!",A_REPLACE|A_SHADOWED|A_CENTERED);
						DrawString(10,66,SGameCompleted,A_REPLACE|A_SHADOWED|A_CENTERED);
						//DrawGrayStrExt2B(10,78,"Congratulations!",A_REPLACE|A_SHADOWED|A_CENTERED,F_8x10,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						//DrawString(10,78,"Congratulations!",A_REPLACE|A_SHADOWED|A_CENTERED);
						DrawString(10,78,SCongrat,A_REPLACE|A_SHADOWED|A_CENTERED);
						#endif
						#ifdef german
						DrawGrayStrExt2B(10,66,SGameCompleted,A_REPLACE|A_SHADOWED|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						DrawGrayStrExt2B(10,78,SCongrat,A_REPLACE|A_SHADOWED|A_CENTERED,F_6x8,GrayDBufGetActivePlane(LIGHT_PLANE),GrayDBufGetActivePlane(DARK_PLANE));
						#endif
						
						#endif
						
						WaitKeyPress();
						
						Gamedata.Exit = 1;
					};					
				};
			};
		};		
	};		
	
};